/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.common.block.BlockPneumaticDynamo;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.core.ModContainers;
import me.desht.pneumaticcraft.common.core.ModTileEntities;
import me.desht.pneumaticcraft.common.heat.HeatUtil;
import me.desht.pneumaticcraft.common.inventory.ContainerEnergy;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.tileentity.IHeatExchangingTE;
import me.desht.pneumaticcraft.common.tileentity.IRedstoneControl;
import me.desht.pneumaticcraft.common.tileentity.PneumaticEnergyStorage;
import me.desht.pneumaticcraft.common.tileentity.RedstoneController;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPneumaticBase;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;

public class TileEntityFluxCompressor
extends TileEntityPneumaticBase
implements IRedstoneControl<TileEntityFluxCompressor>,
INamedContainerProvider,
IHeatExchangingTE {
    private static final int BASE_FE_PRODUCTION = 40;
    private final PneumaticEnergyStorage energy = new PneumaticEnergyStorage(100000);
    private final LazyOptional<IEnergyStorage> energyCap = LazyOptional.of(() -> this.energy);
    @GuiSynced
    private int rfPerTick;
    @GuiSynced
    private float airPerTick;
    private float airBuffer;
    private boolean isEnabled;
    @GuiSynced
    private final RedstoneController<TileEntityFluxCompressor> rsController = new RedstoneController<TileEntityFluxCompressor>(this);
    @GuiSynced
    private final IHeatExchangerLogic heatExchanger = PneumaticRegistry.getInstance().getHeatRegistry().makeHeatExchangerLogic();
    private final LazyOptional<IHeatExchangerLogic> heatCap = LazyOptional.of(() -> this.heatExchanger);

    public TileEntityFluxCompressor() {
        super((TileEntityType)ModTileEntities.FLUX_COMPRESSOR.get(), 20.0f, 25.0f, 10000, 4);
        this.heatExchanger.setThermalCapacity(100.0);
    }

    public int getHeatEfficiency() {
        return HeatUtil.getEfficiency(this.heatExchanger.getTemperatureAsInt());
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            if (this.field_145850_b.func_82737_E() % 5L == 0L) {
                this.airPerTick = 40.0f * this.getSpeedUsageMultiplierFromUpgrades() * ((float)this.getHeatEfficiency() / 100.0f) * ((float)((Integer)ConfigHelper.common().machines.fluxCompressorEfficiency.get()).intValue() / 100.0f);
                this.rfPerTick = (int)(40.0f * this.getSpeedUsageMultiplierFromUpgrades());
            }
            boolean newEnabled = false;
            if (this.rsController.shouldRun() && this.energy.getEnergyStored() >= this.rfPerTick) {
                this.airBuffer += this.airPerTick;
                if (this.airBuffer >= 1.0f) {
                    int toAdd = (int)this.airBuffer;
                    this.addAir(toAdd);
                    this.airBuffer -= (float)toAdd;
                    this.heatExchanger.addHeat((double)toAdd / 20.0);
                }
                this.energy.extractEnergy(this.rfPerTick, false);
                newEnabled = true;
            }
            if ((this.field_145850_b.func_82737_E() & 7L) == 0L && newEnabled != this.isEnabled) {
                this.isEnabled = newEnabled;
                BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
                this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)state.func_206870_a((Property)BlockPneumaticDynamo.ACTIVE, (Comparable)Boolean.valueOf(this.isEnabled)));
            }
            this.airHandler.setSideLeaking(this.hasNoConnectedAirHandlers() ? this.getRotation().func_176734_d() : null);
        }
    }

    @Override
    public boolean canConnectPneumatic(Direction side) {
        return side == this.getRotation().func_176734_d();
    }

    @Override
    public RedstoneController<TileEntityFluxCompressor> getRedstoneController() {
        return this.rsController;
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityEnergy.ENERGY && side != this.getRotation().func_176734_d()) {
            return this.energyCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        this.energy.writeToNBT(tag);
        return tag;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.energy.readFromNBT(tag);
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayerEntity player) {
        this.rsController.parseRedstoneMode(tag);
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return null;
    }

    @Override
    public LazyOptional<IHeatExchangerLogic> getHeatCap(Direction side) {
        return this.heatCap;
    }

    public int getInfoEnergyPerTick() {
        return this.rfPerTick;
    }

    public int getInfoEnergyStored() {
        return this.energy.getEnergyStored();
    }

    public float getAirRate() {
        return this.airPerTick;
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerEnergy((ContainerType)ModContainers.FLUX_COMPRESSOR.get(), i, playerInventory, this.func_174877_v());
    }

    @Override
    public IHeatExchangerLogic getHeatExchanger(Direction dir) {
        return this.heatExchanger;
    }
}

