/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.client.sound.MovingSounds;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.block.BlockElevatorBase;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.core.ModSounds;
import me.desht.pneumaticcraft.common.core.ModTileEntities;
import me.desht.pneumaticcraft.common.inventory.ContainerElevator;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.network.LazySynced;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketPlayMovingSound;
import me.desht.pneumaticcraft.common.network.PacketServerTickTime;
import me.desht.pneumaticcraft.common.thirdparty.computer_common.LuaMethod;
import me.desht.pneumaticcraft.common.thirdparty.computer_common.LuaMethodRegistry;
import me.desht.pneumaticcraft.common.tileentity.ICamouflageableTE;
import me.desht.pneumaticcraft.common.tileentity.IGUITextFieldSensitive;
import me.desht.pneumaticcraft.common.tileentity.IMinWorkingPressure;
import me.desht.pneumaticcraft.common.tileentity.IRedstoneControl;
import me.desht.pneumaticcraft.common.tileentity.RedstoneController;
import me.desht.pneumaticcraft.common.tileentity.TileEntityElevatorCaller;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPneumaticBase;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class TileEntityElevatorBase
extends TileEntityPneumaticBase
implements IGUITextFieldSensitive,
IRedstoneControl<TileEntityElevatorBase>,
IMinWorkingPressure,
ICamouflageableTE,
INamedContainerProvider {
    private static final List<RedstoneController.RedstoneMode<TileEntityElevatorBase>> REDSTONE_LABELS = ImmutableList.of(new RedstoneController.ReceivingRedstoneMode<TileEntityElevatorBase>("elevator.redstone", new ItemStack((IItemProvider)Items.field_151137_ax), te -> true), new RedstoneController.ReceivingRedstoneMode<TileEntityElevatorBase>("elevator.caller", new ItemStack((IItemProvider)ModBlocks.ELEVATOR_CALLER.get()), te -> true));
    private static final float BUTTON_HEIGHT = 0.06f;
    private static final float BUTTON_SPACING = 0.02f;
    private static final byte RS_REDSTONE_MODE = 0;
    private static final byte RS_CALLER_MODE = 1;
    @DescSynced
    @LazySynced
    public double extension;
    @DescSynced
    private double targetExtension;
    @DescSynced
    double syncedSpeedMult;
    @DescSynced
    public int multiElevatorCount;
    @GuiSynced
    private final RedstoneController<TileEntityElevatorBase> rsController = new RedstoneController<TileEntityElevatorBase>(this, REDSTONE_LABELS);
    @GuiSynced
    private int maxFloorHeight;
    @DescSynced
    private int chargingUpgrades;
    public double oldExtension;
    private boolean isStopped = true;
    private TileEntityElevatorBase coreElevator;
    private List<TileEntityElevatorBase> multiElevators;
    public int[] floorHeights = new int[0];
    private HashMap<Integer, String> floorNames = new HashMap();
    private int redstoneInputLevel;
    private BlockState camoState;
    private BlockState prevCamoState;
    public int ticksRunning;
    private final List<Integer> floorList = new ArrayList<Integer>();
    private final List<BlockPos> callerList = new ArrayList<BlockPos>();
    private long lastFloorUpdate = 0L;
    public float[] fakeFloorTextureUV;
    public int lightAbove;

    public TileEntityElevatorBase() {
        super((TileEntityType)ModTileEntities.ELEVATOR_BASE.get(), 5.0f, 7.0f, 10000, 4);
    }

    @Override
    public void func_73660_a() {
        double speedMultiplier;
        this.oldExtension = this.extension;
        super.func_73660_a();
        if (!this.isCoreElevator()) {
            this.extension = 0.0;
            return;
        }
        if (!this.func_145831_w().field_72995_K) {
            if (this.isControlledByRedstone()) {
                this.handleRedstoneControl();
            }
            speedMultiplier = this.syncedSpeedMult = (double)this.getSpeedMultiplierFromUpgrades();
            this.chargingUpgrades = this.getUpgrades(EnumUpgrade.CHARGING);
        } else {
            speedMultiplier = (float)(this.syncedSpeedMult * PacketServerTickTime.tickTimeMultiplier);
            if (this.prevCamoState != this.camoState) {
                this.fakeFloorTextureUV = ClientUtils.getTextureUV(this.camoState, Direction.UP);
                this.prevCamoState = this.camoState;
            }
            if ((this.func_145831_w().func_82737_E() & 0xFL) == 0L) {
                this.lightAbove = ClientUtils.getLightAt(this.field_174879_c.func_177984_a());
            }
        }
        if (this.extension < this.targetExtension) {
            if (!this.func_145831_w().field_72995_K && this.getPressure() < 3.0f) {
                this.targetExtension = this.extension;
            }
            double moveBy = this.extension < this.targetExtension - 0.5 ? (double)0.05f * speedMultiplier : (double)0.02f * speedMultiplier;
            this.extension = Math.min(this.targetExtension, this.extension + moveBy);
            this.addAir((int)((this.oldExtension - this.extension) * 300.0 * ((double)this.getSpeedUsageMultiplierFromUpgrades() / speedMultiplier)));
        } else if (this.extension > this.targetExtension) {
            double chargingSlowdown = 1.0 - (double)this.chargingUpgrades * 0.1;
            double moveBy = this.extension > this.targetExtension + 0.5 ? (double)0.05f * speedMultiplier * chargingSlowdown : (double)0.02f * speedMultiplier * chargingSlowdown;
            this.extension = Math.max(this.targetExtension, this.extension - moveBy);
            if (!this.func_145831_w().field_72995_K && this.chargingUpgrades > 0 && this.getPressure() < this.airHandler.getDangerPressure() - 0.1f) {
                float mul = 0.15f * (float)Math.min(4, this.chargingUpgrades);
                this.addAir((int)((this.oldExtension - this.extension) * 300.0 * (double)mul * ((double)this.getSpeedUsageMultiplierFromUpgrades() / speedMultiplier)));
            }
        }
        if (PneumaticCraftUtils.epsilonEquals(this.oldExtension, this.extension) && !this.isStopped) {
            this.isStopped = true;
            this.ticksRunning = 0;
            this.playStopStartSound();
            if (!this.func_145831_w().field_72995_K) {
                this.updateFloors(false);
            }
        } else if (!PneumaticCraftUtils.epsilonEquals(this.oldExtension, this.extension) && this.isStopped) {
            this.isStopped = false;
            this.playStopStartSound();
        }
        if (!this.isStopped) {
            ++this.ticksRunning;
        }
    }

    @Override
    protected void onFirstServerTick() {
        super.onFirstServerTick();
        this.connectAsMultiblock();
    }

    private void playStopStartSound() {
        if (this.shouldPlaySounds()) {
            if (this.func_145831_w().func_201670_d()) {
                this.func_145831_w().func_184134_a((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + this.extension, (double)this.func_174877_v().func_177952_p() + 0.5, this.isStopped ? (SoundEvent)ModSounds.ELEVATOR_RISING_STOP.get() : (SoundEvent)ModSounds.ELEVATOR_RISING_START.get(), SoundCategory.BLOCKS, ((Double)ConfigHelper.client().sound.elevatorVolumeStartStop.get()).floatValue(), 1.0f, true);
            } else if (!this.isStopped) {
                NetworkHandler.sendToAllTracking((Object)new PacketPlayMovingSound(MovingSounds.Sound.ELEVATOR, PacketPlayMovingSound.SoundSource.of(this.getCoreElevator())), this);
            }
        }
    }

    private boolean shouldPlaySounds() {
        return !(this.getCachedNeighbor(Direction.EAST) instanceof TileEntityElevatorBase) && !(this.getCachedNeighbor(Direction.SOUTH) instanceof TileEntityElevatorBase);
    }

    public boolean isStopped() {
        return this.isStopped;
    }

    private void handleRedstoneControl() {
        double oldTargetExtension = this.targetExtension;
        float maxExtension = this.getMaxElevatorHeight();
        int redstoneInput = this.redstoneInputLevel;
        if (this.multiElevators != null) {
            for (TileEntityElevatorBase base : this.multiElevators) {
                redstoneInput = Math.max(this.redstoneInputLevel, base.redstoneInputLevel);
            }
        }
        this.targetExtension = (float)redstoneInput * maxExtension / 15.0f;
        if (this.targetExtension > this.oldExtension && this.getPressure() < 3.0f) {
            this.targetExtension = this.oldExtension;
        }
        if (oldTargetExtension != this.targetExtension) {
            this.sendDescPacketFromAllElevators();
        }
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayerEntity player) {
        this.rsController.parseRedstoneMode(tag);
    }

    @Override
    public void onRedstoneModeChanged(int newModeIdx) {
        if (this.multiElevators != null) {
            for (TileEntityElevatorBase base : this.multiElevators) {
                base.getRedstoneController().setCurrentMode(newModeIdx);
            }
        }
        int i = -1;
        TileEntity te = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(Direction.DOWN));
        while (te instanceof TileEntityElevatorBase) {
            ((TileEntityElevatorBase)te).getRedstoneController().setCurrentMode(newModeIdx);
            te = this.func_145831_w().func_175625_s(this.func_174877_v().func_177982_a(0, --i, 0));
        }
    }

    private boolean isControlledByRedstone() {
        return this.getRedstoneController().getCurrentMode() == 0;
    }

    private void updateRedstoneInputLevel() {
        if (this.multiElevators == null) {
            return;
        }
        int maxRedstone = this.getMaxRedstone();
        for (TileEntityElevatorBase base : this.multiElevators) {
            base.redstoneInputLevel = maxRedstone;
        }
    }

    private int getMaxRedstone() {
        int maxRedstone = 0;
        for (TileEntityElevatorBase base : this.multiElevators) {
            BlockPos.Mutable pos1 = base.func_174877_v().func_239590_i_();
            while (this.func_145831_w().func_180495_p((BlockPos)pos1).func_177230_c() == ModBlocks.ELEVATOR_BASE.get()) {
                if ((maxRedstone = Math.max(maxRedstone, this.func_145831_w().func_175687_A((BlockPos)pos1))) == 15) {
                    return 15;
                }
                pos1.func_189536_c(Direction.DOWN);
            }
        }
        return maxRedstone;
    }

    public float getMaxElevatorHeight() {
        int max = this.maxFloorHeight;
        if (this.multiElevators != null) {
            for (TileEntityElevatorBase base : this.multiElevators) {
                max = Math.min(max, base.maxFloorHeight);
            }
        }
        return max;
    }

    public void updateMaxElevatorHeight() {
        int i = -1;
        while (this.func_145831_w().func_180495_p(this.func_174877_v().func_177982_a(0, ++i + 1, 0)).func_177230_c() == ModBlocks.ELEVATOR_FRAME.get()) {
        }
        int elevatorBases = 0;
        while (this.func_145831_w().func_180495_p(this.func_174877_v().func_177982_a(0, -(++elevatorBases), 0)).func_177230_c() == ModBlocks.ELEVATOR_BASE.get()) {
        }
        this.maxFloorHeight = Math.min(i, elevatorBases * (Integer)ConfigHelper.common().machines.elevatorBaseBlocksPerBase.get());
        this.func_70296_d();
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        if (tag.func_74764_b("extensionD")) {
            this.extension = tag.func_74769_h("extensionD");
            this.targetExtension = tag.func_74769_h("targetExtensionD");
        } else {
            this.extension = tag.func_74760_g("extension");
            this.targetExtension = tag.func_74760_g("targetExtension");
        }
        if (!tag.func_74764_b("maxFloorHeight")) {
            this.updateMaxElevatorHeight();
        } else {
            this.maxFloorHeight = tag.func_74762_e("maxFloorHeight");
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        tag.func_74780_a("extensionD", this.extension);
        tag.func_74780_a("targetExtensionD", this.targetExtension);
        tag.func_74768_a("maxFloorHeight", this.maxFloorHeight);
        return tag;
    }

    @Override
    public void readFromPacket(CompoundNBT tag) {
        super.readFromPacket(tag);
        this.camoState = ICamouflageableTE.readCamo(tag);
        this.floorHeights = tag.func_74759_k("floorHeights");
        this.floorNames.clear();
        ListNBT floorNameList = tag.func_150295_c("floorNames", 10);
        for (int i = 0; i < floorNameList.size(); ++i) {
            CompoundNBT floorName = floorNameList.func_150305_b(i);
            this.floorNames.put(floorName.func_74762_e("floorHeight"), floorName.func_74779_i("floorName"));
        }
    }

    @Override
    public void writeToPacket(CompoundNBT tag) {
        super.writeToPacket(tag);
        ICamouflageableTE.writeCamo(tag, this.camoState);
        tag.func_74783_a("floorHeights", this.floorHeights);
        ListNBT floorNameList = new ListNBT();
        this.floorNames.forEach((height, name) -> {
            CompoundNBT floorNameTag = new CompoundNBT();
            floorNameTag.func_74768_a("floorHeight", height.intValue());
            floorNameTag.func_74778_a("floorName", name);
            floorNameList.add((Object)floorNameTag);
        });
        tag.func_218657_a("floorNames", (INBT)floorNameList);
    }

    private void connectAsMultiblock() {
        this.multiElevators = null;
        if (this.isCoreElevator()) {
            this.multiElevators = new ArrayList<TileEntityElevatorBase>();
            Stack<TileEntityElevatorBase> todo = new Stack<TileEntityElevatorBase>();
            todo.add(this);
            while (!todo.isEmpty()) {
                TileEntityElevatorBase curElevator = (TileEntityElevatorBase)todo.pop();
                if (!curElevator.isCoreElevator() || this.multiElevators.contains(curElevator)) continue;
                this.multiElevators.add(curElevator);
                curElevator.multiElevators = this.multiElevators;
                for (Direction face : DirectionUtil.HORIZONTALS) {
                    TileEntity te = curElevator.getCachedNeighbor(face);
                    if (!(te instanceof TileEntityElevatorBase) || te.func_145837_r()) continue;
                    todo.push((TileEntityElevatorBase)te);
                }
            }
            this.multiElevatorCount = this.multiElevators.size();
        }
    }

    @Override
    public void onNeighborBlockUpdate(BlockPos fromPos) {
        super.onNeighborBlockUpdate(fromPos);
        this.getCoreElevator().updateRedstoneInputLevel();
        this.connectAsMultiblock();
        this.updateConnections();
    }

    private void updateConnections() {
        this.coreElevator = this.func_145831_w().func_180495_p(this.func_174877_v().func_177972_a(Direction.UP)).func_177230_c() != ModBlocks.ELEVATOR_BASE.get() ? this : null;
    }

    public void moveUpgradesFromAbove() {
        TileEntity brokenTE = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(Direction.UP));
        if (brokenTE instanceof TileEntityElevatorBase) {
            this.camoState = ((TileEntityElevatorBase)brokenTE).camoState;
            this.sendDescriptionPacket();
            for (int i = 0; i < this.getUpgradeHandler().getSlots(); ++i) {
                ItemStack stack = ((TileEntityElevatorBase)brokenTE).getUpgradeHandler().getStackInSlot(i);
                ItemStack excess = ItemHandlerHelper.insertItem((IItemHandler)this.getUpgradeHandler(), (ItemStack)stack, (boolean)false);
                if (!excess.func_190926_b()) {
                    PneumaticCraftUtils.dropItemOnGround(excess, this.field_145850_b, this.func_174877_v());
                }
                ((TileEntityElevatorBase)brokenTE).getUpgradeHandler().setStackInSlot(i, ItemStack.field_190927_a);
            }
        }
    }

    public void updateFloors(boolean notifyClient) {
        if (this.field_145850_b.func_82737_E() - this.lastFloorUpdate > 20L) {
            this.callerList.clear();
            this.floorList.clear();
            if (this.multiElevators != null) {
                int yOffset = 0;
                int worldHeight = this.field_145850_b.func_230315_m_().func_241513_m_();
                BlockPos.Mutable mut = new BlockPos.Mutable();
                block0: while (this.field_174879_c.func_177956_o() + yOffset < worldHeight - 2) {
                    boolean registeredThisFloor = false;
                    for (TileEntityElevatorBase base : this.multiElevators) {
                        for (Direction dir : DirectionUtil.HORIZONTALS) {
                            mut.func_189533_g((Vector3i)base.func_174877_v());
                            mut.func_196234_d(dir.func_82601_c(), yOffset + 2, dir.func_82599_e());
                            if (base.field_145850_b.func_180495_p((BlockPos)mut).func_177230_c() != ModBlocks.ELEVATOR_CALLER.get()) continue;
                            this.callerList.add(mut.func_185334_h());
                            if (!registeredThisFloor) {
                                this.floorList.add(yOffset);
                            }
                            registeredThisFloor = true;
                        }
                    }
                    ++yOffset;
                    for (TileEntityElevatorBase base : this.multiElevators) {
                        if (base.field_145850_b.func_180495_p(base.func_174877_v().func_177981_b(yOffset)).func_177230_c() == ModBlocks.ELEVATOR_FRAME.get()) continue;
                        break block0;
                    }
                }
                for (TileEntityElevatorBase base : this.multiElevators) {
                    base.floorHeights = this.floorList.stream().mapToInt(Integer::intValue).toArray();
                }
            }
            this.lastFloorUpdate = this.field_145850_b.func_82737_E();
        }
        TileEntityElevatorCaller.ElevatorButton[] elevatorButtons = new TileEntityElevatorCaller.ElevatorButton[this.floorHeights.length];
        int columns = (elevatorButtons.length - 1) / 12 + 1;
        for (int j = 0; j < columns; ++j) {
            for (int i = j * 12; i < this.floorHeights.length && i < j * 12 + 12; ++i) {
                elevatorButtons[i] = new TileEntityElevatorCaller.ElevatorButton(0.2f + 0.6f / (float)columns * (float)j, 0.5f + (float)(Math.min(this.floorHeights.length, 12) - 2) * 0.08f / 2.0f - (float)(i % 12) * 0.08f, 0.58f / (float)columns, 0.06f, i, this.floorHeights[i]);
                elevatorButtons[i].setColor((double)this.floorHeights[i] == this.targetExtension ? 0.0f : 1.0f, 1.0f, (double)this.floorHeights[i] == this.targetExtension ? 0.0f : 1.0f);
                String floorName = this.floorNames.get(this.floorHeights[i]);
                if (floorName != null) {
                    elevatorButtons[i].buttonText = floorName;
                    continue;
                }
                this.floorNames.put(this.floorHeights[i], elevatorButtons[i].buttonText);
            }
        }
        if (this.multiElevators != null) {
            for (TileEntityElevatorBase base : this.multiElevators) {
                base.floorNames = new HashMap<Integer, String>(this.floorNames);
            }
        }
        for (BlockPos p : this.callerList) {
            TileEntity te = this.func_145831_w().func_175625_s(p);
            if (!(te instanceof TileEntityElevatorCaller)) continue;
            TileEntityElevatorCaller caller = (TileEntityElevatorCaller)te;
            int callerFloorHeight = p.func_177956_o() - this.func_174877_v().func_177956_o() - 2;
            int callerFloor = -1;
            for (TileEntityElevatorCaller.ElevatorButton floor : elevatorButtons) {
                if (floor.floorHeight != callerFloorHeight) continue;
                callerFloor = floor.floorNumber;
                break;
            }
            if (callerFloor == -1) {
                Log.error("Error while updating elevator floors! This will cause a indexOutOfBoundsException, index = -1", new Object[0]);
            }
            caller.setEmittingRedstone(PneumaticCraftUtils.epsilonEquals(this.targetExtension, this.extension, 0.1) && PneumaticCraftUtils.epsilonEquals(this.extension, (double)callerFloorHeight, 0.1));
            caller.setFloors(elevatorButtons, callerFloor);
        }
        if (notifyClient && !this.field_145850_b.field_72995_K) {
            this.sendDescPacketFromAllElevators();
        }
    }

    public void goToFloor(int floor) {
        if (this.getCoreElevator().isControlledByRedstone()) {
            this.getCoreElevator().getRedstoneController().setCurrentMode(1);
        }
        if (floor >= 0 && floor < this.floorHeights.length) {
            this.setTargetHeight(this.floorHeights[floor]);
        }
        this.updateFloors(false);
        this.sendDescPacketFromAllElevators();
    }

    private void setTargetHeight(float height) {
        height = Math.min(height, this.getMaxElevatorHeight());
        if (this.multiElevators != null) {
            for (TileEntityElevatorBase base : this.multiElevators) {
                base.targetExtension = height;
            }
        }
    }

    public double getTargetExtension() {
        return this.targetExtension;
    }

    private void sendDescPacketFromAllElevators() {
        if (this.multiElevators != null) {
            for (TileEntityElevatorBase base : this.multiElevators) {
                base.sendDescriptionPacket();
            }
        } else {
            this.sendDescriptionPacket();
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (double)(this.func_174877_v().func_177958_n() + 1), (double)(this.func_174877_v().func_177956_o() + 1) + this.extension, (double)(this.func_174877_v().func_177952_p() + 1));
    }

    public double func_145833_n() {
        return 65536.0;
    }

    private TileEntityElevatorBase getCoreElevator() {
        if (this.coreElevator == null || this.func_145831_w().field_72995_K && (this.func_145831_w().func_82737_E() & 0x3FL) == 0L) {
            this.coreElevator = BlockElevatorBase.getCoreTileEntity(this.func_145831_w(), this.func_174877_v());
        }
        return this.coreElevator;
    }

    public boolean isCoreElevator() {
        return this.getCoreElevator() == this;
    }

    @Override
    public boolean canConnectPneumatic(Direction side) {
        return side != Direction.UP || this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(side)).func_177230_c() == ModBlocks.ELEVATOR_BASE.get();
    }

    @Override
    public void setText(int textFieldID, String text) {
        this.setFloorName(textFieldID, text);
    }

    @Override
    public String getText(int textFieldID) {
        return this.getFloorName(textFieldID);
    }

    public String getFloorName(int floor) {
        return floor < this.floorHeights.length ? this.floorNames.get(this.floorHeights[floor]) : "";
    }

    public void setFloorName(int floor, String name) {
        if (floor < this.floorHeights.length) {
            this.floorNames.put(this.floorHeights[floor], name);
            this.updateFloors(true);
        }
    }

    @Override
    public boolean isGuiUseableByPlayer(PlayerEntity par1EntityPlayer) {
        return this.func_145831_w().func_175625_s(this.func_174877_v()) == this;
    }

    @Override
    public void addLuaMethods(LuaMethodRegistry registry) {
        super.addLuaMethods(registry);
        registry.registerLuaMethod(new LuaMethod("setHeight"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "height (in blocks)");
                TileEntityElevatorBase.this.setTargetHeight(((Double)args[0]).floatValue());
                if (TileEntityElevatorBase.this.getCoreElevator().isControlledByRedstone()) {
                    TileEntityElevatorBase.this.getCoreElevator().getRedstoneController().setCurrentMode(1);
                }
                TileEntityElevatorBase.this.getCoreElevator().sendDescPacketFromAllElevators();
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("getCurrentHeight"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                return new Object[]{((TileEntityElevatorBase)TileEntityElevatorBase.this).getCoreElevator().extension};
            }
        });
        registry.registerLuaMethod(new LuaMethod("getTargetHeight"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                return new Object[]{TileEntityElevatorBase.this.getCoreElevator().targetExtension};
            }
        });
        registry.registerLuaMethod(new LuaMethod("getVelocity"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                return new Object[]{((TileEntityElevatorBase)TileEntityElevatorBase.this).getCoreElevator().extension - ((TileEntityElevatorBase)TileEntityElevatorBase.this).getCoreElevator().oldExtension};
            }
        });
        registry.registerLuaMethod(new LuaMethod("setExternalControl"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "true/false");
                if (((Boolean)args[0]).booleanValue() && TileEntityElevatorBase.this.getCoreElevator().isControlledByRedstone() || !((Boolean)args[0]).booleanValue() && !TileEntityElevatorBase.this.getCoreElevator().isControlledByRedstone()) {
                    TileEntityElevatorBase.this.getCoreElevator().getRedstoneController().setCurrentMode(1);
                }
                return null;
            }
        });
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return null;
    }

    @Override
    public RedstoneController<TileEntityElevatorBase> getRedstoneController() {
        return this.rsController;
    }

    @Override
    public float getMinWorkingPressure() {
        return 3.0f;
    }

    @Override
    public BlockState getCamouflage() {
        return this.camoState;
    }

    @Override
    public void setCamouflage(BlockState state) {
        this.camoState = state;
        ICamouflageableTE.syncToClient(this);
    }

    @Override
    public IFormattableTextComponent getRedstoneTabTitle() {
        return PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.redstoneBehaviour.elevator.controlBy", new Object[0]);
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerElevator(i, playerInventory, this.func_174877_v());
    }
}

