/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.theoneprobe;

import java.util.ArrayList;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.semiblock.ISemiBlock;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerMachine;
import me.desht.pneumaticcraft.common.block.BlockPressureTube;
import me.desht.pneumaticcraft.common.block.tubes.TubeModule;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.heat.HeatUtil;
import me.desht.pneumaticcraft.common.heat.TemperatureData;
import me.desht.pneumaticcraft.common.item.ItemCamoApplicator;
import me.desht.pneumaticcraft.common.thirdparty.theoneprobe.ElementPressure;
import me.desht.pneumaticcraft.common.thirdparty.waila.IInfoForwarder;
import me.desht.pneumaticcraft.common.tileentity.ICamouflageableTE;
import me.desht.pneumaticcraft.common.tileentity.IRedstoneControl;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPressureTube;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TOPInfoProvider {
    private static final TextFormatting COLOR = TextFormatting.GRAY;

    static void handleBlock(ProbeMode mode, IProbeInfo probeInfo, PlayerEntity player, World world, BlockState blockState, IProbeHitData data) {
        TileEntity te = world.func_175625_s(data.getPos());
        if (te instanceof IInfoForwarder) {
            te = ((IInfoForwarder)te).getInfoTileEntity();
        }
        if (te == null) {
            return;
        }
        if (te.getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY).isPresent()) {
            TOPInfoProvider.handlePneumatic(mode, probeInfo, te);
        }
        if (te.getCapability(PNCCapabilities.HEAT_EXCHANGER_CAPABILITY).isPresent()) {
            TOPInfoProvider.handleHeat(mode, probeInfo, te);
        }
        if (((Boolean)ConfigHelper.client().general.topShowsFluids.get()).booleanValue()) {
            te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, data.getSideHit()).ifPresent(handler -> TOPInfoProvider.handleFluidTanks(mode, probeInfo, handler));
        }
        if (te instanceof IRedstoneControl) {
            TOPInfoProvider.handleRedstoneMode(mode, probeInfo, (IRedstoneControl)te);
        }
        if (te instanceof TileEntityPressureTube) {
            TOPInfoProvider.handlePressureTube(mode, probeInfo, (TileEntityPressureTube)te, data.getSideHit(), player);
        }
        if (te instanceof ICamouflageableTE) {
            TOPInfoProvider.handleCamo(mode, probeInfo, ((ICamouflageableTE)te).getCamouflage());
        }
    }

    static void handleSemiblock(PlayerEntity player, ProbeMode mode, IProbeInfo probeInfo, ISemiBlock semiBlock) {
        IProbeInfo vert = probeInfo.vertical(probeInfo.defaultLayoutStyle().borderColor(Integer.valueOf(semiBlock.getColor())));
        IProbeInfo horiz = vert.horizontal();
        NonNullList<ItemStack> drops = semiBlock.getDrops();
        if (!drops.isEmpty()) {
            ItemStack stack = (ItemStack)drops.get(0);
            horiz.item(stack);
            horiz.text(stack.func_200301_q());
            ArrayList<ITextComponent> currenttip = new ArrayList<ITextComponent>();
            semiBlock.addTooltip(currenttip, player, stack.func_77978_p(), player.func_225608_bj_());
            currenttip.forEach(arg_0 -> ((IProbeInfo)vert).text(arg_0));
        }
    }

    private static void handlePneumatic(ProbeMode mode, IProbeInfo probeInfo, TileEntity pneumaticMachine) {
        pneumaticMachine.getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY).ifPresent(airHandler -> {
            String pressure = PneumaticCraftUtils.roundNumberTo(airHandler.getPressure(), 2);
            String dangerPressure = PneumaticCraftUtils.roundNumberTo(airHandler.getDangerPressure(), 1);
            probeInfo.text((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.maxPressure", dangerPressure).func_240699_a_(COLOR));
            if (mode == ProbeMode.EXTENDED) {
                probeInfo.text((ITextComponent)new StringTextComponent("Pressure:").func_240699_a_(COLOR));
                probeInfo.horizontal().element((IElement)new ElementPressure(pneumaticMachine, (IAirHandlerMachine)airHandler)).vertical().text(StringTextComponent.field_240750_d_).text((ITextComponent)new StringTextComponent(" \u2b05 " + pressure + " bar"));
            } else {
                probeInfo.text((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.pressure", pressure));
            }
        });
    }

    private static void handleHeat(ProbeMode mode, IProbeInfo probeInfo, TileEntity heatExchanger) {
        TemperatureData tempData = new TemperatureData((ICapabilityProvider)heatExchanger);
        if (tempData.isMultisided()) {
            for (Direction face : DirectionUtil.VALUES) {
                if (!tempData.hasData(face)) continue;
                probeInfo.text(HeatUtil.formatHeatString(face, (int)tempData.getTemperature(face)));
            }
        } else if (tempData.hasData(null)) {
            probeInfo.text(HeatUtil.formatHeatString((int)tempData.getTemperature(null)));
        }
    }

    private static void handleRedstoneMode(ProbeMode mode, IProbeInfo probeInfo, IRedstoneControl<?> redstoneControl) {
        probeInfo.text(redstoneControl.getRedstoneController().getDescription());
    }

    private static void handlePressureTube(ProbeMode mode, IProbeInfo probeInfo, TileEntityPressureTube te, Direction face, PlayerEntity player) {
        TubeModule module = BlockPressureTube.getFocusedModule(te.func_145831_w(), te.func_174877_v(), player);
        if (module != null) {
            ArrayList<ITextComponent> currenttip = new ArrayList<ITextComponent>();
            module.addInfo(currenttip);
            if (!currenttip.isEmpty()) {
                IProbeInfo vert = probeInfo.vertical(probeInfo.defaultLayoutStyle().borderColor(Integer.valueOf(-12566273)));
                currenttip.forEach(arg_0 -> ((IProbeInfo)vert).text(arg_0));
            }
        }
    }

    static void handleFluidTanks(ProbeMode mode, IProbeInfo probeInfo, IFluidHandler handler) {
        if (mode == ProbeMode.EXTENDED) {
            for (int i = 0; i < handler.getTanks(); ++i) {
                FluidStack fluidStack = handler.getFluidInTank(i);
                TranslationTextComponent fluidDesc = fluidStack.isEmpty() ? PneumaticCraftUtils.xlate("pneumaticcraft.gui.misc.empty", new Object[0]) : new StringTextComponent(fluidStack.getAmount() + "mB ").func_230529_a_((ITextComponent)PneumaticCraftUtils.xlate(fluidStack.getTranslationKey(), new Object[0]));
                probeInfo.text((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.waila.tank", i + 1, fluidDesc.func_230532_e_().func_240699_a_(TextFormatting.AQUA)));
            }
        }
    }

    private static void handleCamo(ProbeMode mode, IProbeInfo probeInfo, BlockState camo) {
        if (camo != null) {
            probeInfo.text((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.waila.camo", ItemCamoApplicator.getCamoStateDisplayName(camo)));
        }
    }
}

