/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.patchouli;

import me.desht.pneumaticcraft.api.crafting.recipe.AmadronRecipe;
import me.desht.pneumaticcraft.common.recipes.PneumaticCraftRecipeType;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class ProcessorAmadronTrade
implements IComponentProcessor {
    private AmadronRecipe recipe = null;
    private String text = null;

    public void setup(IVariableProvider iVariableProvider) {
        ResourceLocation recipeId = new ResourceLocation(iVariableProvider.get("recipe").asString());
        this.recipe = PneumaticCraftRecipeType.AMADRON_OFFERS.getRecipe((World)Minecraft.func_71410_x().field_71441_e, recipeId);
        if (this.recipe == null) {
            Log.warning("Missing amadron offer recipe: " + recipeId, new Object[0]);
        }
        this.text = iVariableProvider.has("text") ? iVariableProvider.get("text").asString() : null;
    }

    public IVariable process(String key) {
        if (this.recipe == null) {
            return null;
        }
        switch (key) {
            case "input": {
                return IVariable.from((Object)this.recipe.getInput().apply(itemStack -> itemStack, fluidStack -> fluidStack));
            }
            case "output": {
                return IVariable.from((Object)this.recipe.getOutput().apply(itemStack -> itemStack, fluidStack -> fluidStack));
            }
            case "name": {
                return IVariable.wrap((String)this.recipe.getOutput().getName());
            }
            case "text": {
                return IVariable.wrap((String)(this.text == null ? "" : I18n.func_135052_a((String)this.text, (Object[])new Object[0])));
            }
        }
        return null;
    }
}

