/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.sensor.pollSensors;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.api.universal_sensor.IPollSensorSetting;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class WorldTicktimeSensor
implements IPollSensorSetting {
    @Override
    public String getSensorPath() {
        return "World/Tick time (lag)";
    }

    @Override
    public Set<EnumUpgrade> getRequiredUpgrades() {
        return ImmutableSet.of((Object)((Object)EnumUpgrade.DISPENSER));
    }

    @Override
    public boolean needsTextBox() {
        return true;
    }

    @Override
    public List<String> getDescription() {
        return ImmutableList.of((Object)"pneumaticcraft.gui.universalSensor.desc.world_tick_time");
    }

    @Override
    public int getPollFrequency(TileEntity te) {
        return 40;
    }

    @Override
    public int getRedstoneValue(World world, BlockPos pos, int sensorRange, String textBoxText) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        double worldTickTime = (double)WorldTicktimeSensor.mean(server.getTickTime(world.func_234923_W_())) * 1.0E-6;
        try {
            int redstoneStrength = (int)(worldTickTime * Double.parseDouble(textBoxText));
            return Math.min(15, redstoneStrength);
        }
        catch (Exception e) {
            return 0;
        }
    }

    private static long mean(long[] values) {
        long sum = Arrays.stream(values).sum();
        return sum / (long)values.length;
    }

    @Override
    public void getAdditionalInfo(List<ITextComponent> info) {
        info.add((ITextComponent)new StringTextComponent("Tick Resolution"));
    }
}

