/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.pneumatic_armor.handlers;

import java.util.UUID;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.api.pneumatic_armor.BaseArmorUpgradeHandler;
import me.desht.pneumaticcraft.api.pneumatic_armor.IArmorExtensionData;
import me.desht.pneumaticcraft.api.pneumatic_armor.ICommonArmorHandler;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeMod;

public class ReachDistanceHandler
extends BaseArmorUpgradeHandler<IArmorExtensionData> {
    private static final UUID REACH_DIST_BOOST_ID = UUID.fromString("c9dce729-70c4-4c0f-95d4-31d2e50bc826");
    public static final AttributeModifier REACH_DIST_BOOST = new AttributeModifier(REACH_DIST_BOOST_ID, "Pneumatic Reach Boost", 3.5, AttributeModifier.Operation.ADDITION);
    private final ResourceLocation ID = PneumaticRegistry.RL("reach_distance");

    @Override
    public ResourceLocation getID() {
        return this.ID;
    }

    @Override
    public EnumUpgrade[] getRequiredUpgrades() {
        return new EnumUpgrade[]{EnumUpgrade.RANGE};
    }

    @Override
    public float getIdleAirUsage(ICommonArmorHandler armorHandler) {
        return 5.0f;
    }

    @Override
    public EquipmentSlotType getEquipmentSlot() {
        return EquipmentSlotType.CHEST;
    }

    @Override
    public void tick(ICommonArmorHandler commonArmorHandler, boolean enabled) {
        ModifiableAttributeInstance attr;
        PlayerEntity player = commonArmorHandler.getPlayer();
        if ((player.field_70170_p.func_82737_E() & 0xFL) == 0L && (attr = player.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get())) != null) {
            attr.func_111124_b(REACH_DIST_BOOST);
            if (enabled && commonArmorHandler.hasMinPressure(EquipmentSlotType.CHEST) && commonArmorHandler.isArmorEnabled()) {
                attr.func_233767_b_(REACH_DIST_BOOST);
            }
        }
    }

    @Override
    public void onToggle(ICommonArmorHandler commonArmorHandler, boolean newState) {
        ModifiableAttributeInstance attr;
        if (!newState && (attr = commonArmorHandler.getPlayer().func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get())) != null) {
            attr.func_111124_b(REACH_DIST_BOOST);
        }
    }
}

