/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.pneumatic_armor.handlers;

import java.util.function.Supplier;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IHackableBlock;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IHackableEntity;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.api.pneumatic_armor.BaseArmorUpgradeHandler;
import me.desht.pneumaticcraft.api.pneumatic_armor.IArmorExtensionData;
import me.desht.pneumaticcraft.api.pneumatic_armor.ICommonArmorHandler;
import me.desht.pneumaticcraft.common.advancements.AdvancementTriggers;
import me.desht.pneumaticcraft.common.event.HackTickHandler;
import me.desht.pneumaticcraft.common.hacking.HackManager;
import me.desht.pneumaticcraft.common.hacking.WorldAndCoord;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketHackingBlockFinish;
import me.desht.pneumaticcraft.common.network.PacketHackingEntityFinish;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockReader;

public class HackHandler
extends BaseArmorUpgradeHandler<HackData> {
    @Override
    public ResourceLocation getID() {
        return PneumaticRegistry.RL("hacking");
    }

    @Override
    public EnumUpgrade[] getRequiredUpgrades() {
        return new EnumUpgrade[]{EnumUpgrade.SECURITY};
    }

    @Override
    public float getIdleAirUsage(ICommonArmorHandler armorHandler) {
        return 0.0f;
    }

    @Override
    public EquipmentSlotType getEquipmentSlot() {
        return EquipmentSlotType.HEAD;
    }

    @Override
    public Supplier<HackData> extensionData() {
        return HackData::new;
    }

    @Override
    public void tick(ICommonArmorHandler commonArmorHandler, boolean enabled) {
        PlayerEntity player = commonArmorHandler.getPlayer();
        if (!player.field_70170_p.field_72995_K) {
            commonArmorHandler.getExtensionData(this).tickServerSide(player);
        }
    }

    public static class HackData
    implements IArmorExtensionData {
        private int hackTime;
        private WorldAndCoord hackedBlockPos;
        private Entity hackedEntity;

        private void tickServerSide(PlayerEntity player) {
            if (this.hackedBlockPos != null) {
                this.tickBlockHack(player);
            } else if (this.hackedEntity != null) {
                this.tickEntityHack(player);
            }
        }

        private void tickBlockHack(PlayerEntity player) {
            IHackableBlock hackableBlock = HackManager.getHackableForBlock(this.hackedBlockPos.world, this.hackedBlockPos.pos, player);
            if (hackableBlock != null) {
                IBlockReader world = this.hackedBlockPos.world;
                if (++this.hackTime >= hackableBlock.getHackTime(world, this.hackedBlockPos.pos, player)) {
                    hackableBlock.onHackComplete(player.field_70170_p, this.hackedBlockPos.pos, player);
                    HackTickHandler.instance().trackBlock(player.field_70170_p, this.hackedBlockPos.pos, hackableBlock);
                    NetworkHandler.sendToAllTracking(new PacketHackingBlockFinish(this.hackedBlockPos), player.field_70170_p, player.func_233580_cy_());
                    this.setHackedBlockPos(null);
                    AdvancementTriggers.BLOCK_HACK.trigger((ServerPlayerEntity)player);
                }
            } else {
                this.setHackedBlockPos(null);
            }
        }

        private void tickEntityHack(PlayerEntity player) {
            IHackableEntity hackableEntity = HackManager.getHackableForEntity(this.hackedEntity, player);
            if (hackableEntity != null) {
                if (++this.hackTime >= hackableEntity.getHackTime(this.hackedEntity, player)) {
                    if (this.hackedEntity.func_70089_S()) {
                        hackableEntity.onHackFinished(this.hackedEntity, player);
                        HackTickHandler.instance().trackEntity(this.hackedEntity, hackableEntity);
                        NetworkHandler.sendToAllTracking((Object)new PacketHackingEntityFinish(this.hackedEntity), this.hackedEntity);
                        AdvancementTriggers.ENTITY_HACK.trigger((ServerPlayerEntity)player);
                    }
                    this.setHackedEntity(null);
                }
            } else {
                this.setHackedEntity(null);
            }
        }

        public void setHackedBlockPos(WorldAndCoord pos) {
            this.hackedBlockPos = pos;
            this.hackedEntity = null;
            this.hackTime = 0;
        }

        public void setHackedEntity(Entity entity) {
            this.hackedEntity = entity;
            this.hackedBlockPos = null;
            this.hackTime = 0;
        }
    }
}

