/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.function.Supplier;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticContainerBase;
import me.desht.pneumaticcraft.common.inventory.ContainerPneumaticBase;
import me.desht.pneumaticcraft.common.network.SyncedField;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.inventory.container.Container;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketUpdateGui {
    private final int syncId;
    private final Object value;
    private final byte type;

    public PacketUpdateGui(int syncId, SyncedField<?> syncField) {
        this.syncId = syncId;
        this.value = syncField.getValue();
        this.type = SyncedField.getType(syncField);
    }

    public PacketUpdateGui(PacketBuffer buf) {
        this.syncId = buf.func_150792_a();
        this.type = buf.readByte();
        this.value = SyncedField.fromBytes(buf, this.type);
    }

    public void toBytes(PacketBuffer buf) {
        buf.func_150787_b(this.syncId);
        buf.writeByte((int)this.type);
        SyncedField.toBytes(buf, this.value, this.type);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (Minecraft.func_71410_x().field_71462_r instanceof ContainerScreen) {
                Container container = ((ContainerScreen)Minecraft.func_71410_x().field_71462_r).func_212873_a_();
                if (container instanceof ContainerPneumaticBase) {
                    ((ContainerPneumaticBase)container).updateField(this.syncId, this.value);
                }
                if (Minecraft.func_71410_x().field_71462_r instanceof GuiPneumaticContainerBase) {
                    ((GuiPneumaticContainerBase)Minecraft.func_71410_x().field_71462_r).onGuiUpdate();
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

