/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.common.network.LocationIntPacket;
import me.desht.pneumaticcraft.common.network.PacketUtil;
import me.desht.pneumaticcraft.common.tileentity.TileEntitySmartChest;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.commons.lang3.tuple.Pair;

public class PacketSyncSmartChest
extends LocationIntPacket {
    private final int lastSlot;
    private final List<Pair<Integer, ItemStack>> filter;

    public PacketSyncSmartChest(TileEntitySmartChest te) {
        super(te.func_174877_v());
        this.lastSlot = te.getLastSlot();
        this.filter = te.getFilter();
    }

    PacketSyncSmartChest(PacketBuffer buffer) {
        super(buffer);
        this.lastSlot = buffer.func_150792_a();
        int nFilters = buffer.func_150792_a();
        this.filter = new ArrayList<Pair<Integer, ItemStack>>();
        for (int i = 0; i < nFilters; ++i) {
            int slot = buffer.func_150792_a();
            ItemStack stack = buffer.func_150791_c();
            this.filter.add((Pair<Integer, ItemStack>)Pair.of((Object)slot, (Object)stack));
        }
    }

    @Override
    public void toBytes(PacketBuffer buf) {
        super.toBytes(buf);
        buf.func_150787_b(this.lastSlot);
        buf.func_150787_b(this.filter.size());
        for (Pair<Integer, ItemStack> p : this.filter) {
            buf.func_150787_b(((Integer)p.getLeft()).intValue());
            buf.writeItemStack((ItemStack)p.getRight(), true);
        }
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> PacketUtil.getTE((PlayerEntity)((NetworkEvent.Context)ctx.get()).getSender(), this.pos, TileEntitySmartChest.class).ifPresent(te -> {
            te.setLastSlot(this.lastSlot);
            te.setFilter(this.filter);
        }));
        ctx.get().setPacketHandled(true);
    }
}

