/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.function.Supplier;
import me.desht.pneumaticcraft.common.block.tubes.ModuleRedstone;
import me.desht.pneumaticcraft.common.block.tubes.TubeModule;
import me.desht.pneumaticcraft.common.network.LocationIntPacket;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPressureTube;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketSyncRedstoneModuleToServer
extends LocationIntPacket {
    private final byte side;
    private final byte op;
    private final byte ourColor;
    private final byte otherColor;
    private final int constantVal;
    private final boolean invert;
    private final boolean input;
    private final boolean comparatorInput;

    public PacketSyncRedstoneModuleToServer(ModuleRedstone module) {
        super(module.getTube().func_174877_v());
        this.input = module.getRedstoneDirection() == ModuleRedstone.EnumRedstoneDirection.INPUT;
        this.side = (byte)module.getDirection().ordinal();
        this.op = (byte)module.getOperation().ordinal();
        this.ourColor = (byte)module.getColorChannel();
        this.otherColor = (byte)module.getOtherColor();
        this.constantVal = module.getConstantVal();
        this.invert = module.isInverted();
        this.comparatorInput = module.isComparatorInput();
    }

    PacketSyncRedstoneModuleToServer(PacketBuffer buffer) {
        super(buffer);
        this.side = buffer.readByte();
        this.input = buffer.readBoolean();
        this.ourColor = buffer.readByte();
        if (this.input) {
            this.op = 0;
            this.otherColor = 0;
            this.constantVal = 0;
            this.invert = false;
            this.comparatorInput = buffer.readBoolean();
        } else {
            this.op = buffer.readByte();
            this.otherColor = buffer.readByte();
            this.constantVal = buffer.func_150792_a();
            this.invert = buffer.readBoolean();
            this.comparatorInput = false;
        }
    }

    @Override
    public void toBytes(PacketBuffer buf) {
        super.toBytes(buf);
        buf.writeByte((int)this.side);
        buf.writeBoolean(this.input);
        buf.writeByte((int)this.ourColor);
        if (this.input) {
            buf.writeBoolean(this.comparatorInput);
        } else {
            buf.writeByte((int)this.op);
            buf.writeByte((int)this.otherColor);
            buf.func_150787_b(this.constantVal);
            buf.writeBoolean(this.invert);
        }
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (PneumaticCraftUtils.canPlayerReach((PlayerEntity)player, this.pos)) {
                PneumaticCraftUtils.getTileEntityAt((IBlockReader)player.field_70170_p, this.pos, TileEntityPressureTube.class).ifPresent(te -> {
                    TubeModule tm = te.getModule(Direction.func_82600_a((int)this.side));
                    if (tm instanceof ModuleRedstone) {
                        ModuleRedstone mr = (ModuleRedstone)tm;
                        mr.setRedstoneDirection(this.input ? ModuleRedstone.EnumRedstoneDirection.INPUT : ModuleRedstone.EnumRedstoneDirection.OUTPUT);
                        mr.setColorChannel(this.ourColor);
                        if (this.input) {
                            mr.setComparatorInput(this.comparatorInput);
                        } else {
                            mr.setInverted(this.invert);
                            mr.setOperation(ModuleRedstone.Operation.values()[this.op], this.otherColor, this.constantVal);
                        }
                        mr.updateNeighbors();
                        mr.setInputLevel(-1);
                    }
                });
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

