/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.api.crafting.recipe.AmadronRecipe;
import me.desht.pneumaticcraft.common.amadron.AmadronOfferManager;
import me.desht.pneumaticcraft.common.recipes.amadron.AmadronOffer;
import me.desht.pneumaticcraft.common.recipes.amadron.AmadronPlayerOffer;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketSyncAmadronOffers {
    private final Collection<AmadronRecipe> activeOffers;
    private final boolean notifyPlayer;

    public PacketSyncAmadronOffers(boolean notifyPlayer) {
        this.notifyPlayer = notifyPlayer;
        this.activeOffers = AmadronOfferManager.getInstance().getActiveOffers();
    }

    public PacketSyncAmadronOffers(PacketBuffer buf) {
        this.notifyPlayer = buf.readBoolean();
        this.activeOffers = new ArrayList<AmadronRecipe>();
        int offerCount = buf.func_150792_a();
        for (int i = 0; i < offerCount; ++i) {
            if (buf.readBoolean()) {
                this.activeOffers.add(AmadronPlayerOffer.playerOfferFromBuf(buf.func_192575_l(), buf));
                continue;
            }
            this.activeOffers.add(AmadronOffer.offerFromBuf(buf.func_192575_l(), buf));
        }
    }

    public void toBytes(PacketBuffer buf) {
        buf.writeBoolean(this.notifyPlayer);
        buf.func_150787_b(this.activeOffers.size());
        for (AmadronRecipe offer : this.activeOffers) {
            buf.writeBoolean(offer instanceof AmadronPlayerOffer);
            buf.func_192572_a(offer.func_199560_c());
            offer.write(buf);
        }
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> AmadronOfferManager.getInstance().syncOffers(this.activeOffers, this.notifyPlayer));
        ctx.get().setPacketHandled(true);
    }
}

