/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.function.Supplier;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.amadron.AmadronOfferManager;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.inventory.ContainerAmadronAddTrade;
import me.desht.pneumaticcraft.common.item.ItemAmadronTablet;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketAbstractAmadronTrade;
import me.desht.pneumaticcraft.common.recipes.amadron.AmadronPlayerOffer;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketAmadronTradeAddCustom
extends PacketAbstractAmadronTrade {
    public PacketAmadronTradeAddCustom(AmadronPlayerOffer offer) {
        super(offer);
    }

    public PacketAmadronTradeAddCustom(PacketBuffer buffer) {
        super(buffer);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            AmadronPlayerOffer offer = this.getOffer();
            if (player == null) {
                this.handleClientSide(offer);
            } else {
                this.handleServerSide(player, offer);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private void handleServerSide(ServerPlayerEntity player, AmadronPlayerOffer offer) {
        if (player.field_71070_bA instanceof ContainerAmadronAddTrade) {
            offer.updatePlayerId();
            if (AmadronOfferManager.getInstance().hasSimilarPlayerOffer(offer.getReversedOffer())) {
                player.func_146105_b((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.message.amadron.duplicateReversedOffer", new Object[0]), false);
            } else if (AmadronOfferManager.getInstance().addPlayerOffer(offer)) {
                if (((Boolean)ConfigHelper.common().amadron.notifyOfTradeAddition.get()).booleanValue()) {
                    NetworkHandler.sendToAll(this);
                }
                if (player.func_184614_ca().func_77973_b() == ModItems.AMADRON_TABLET.get()) {
                    ItemAmadronTablet.openGui((PlayerEntity)player, Hand.MAIN_HAND);
                } else if (player.func_184592_cb().func_77973_b() == ModItems.AMADRON_TABLET.get()) {
                    ItemAmadronTablet.openGui((PlayerEntity)player, Hand.OFF_HAND);
                }
            } else {
                player.func_146105_b((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.message.amadron.duplicateOffer", new Object[0]), false);
            }
        }
    }

    private void handleClientSide(AmadronPlayerOffer offer) {
        if (((Boolean)ConfigHelper.common().amadron.notifyOfTradeAddition.get()).booleanValue()) {
            ClientUtils.getClientPlayer().func_146105_b((ITextComponent)new TranslationTextComponent("pneumaticcraft.message.amadron.playerAddedTrade", new Object[]{offer.getVendorName(), offer.getOutput().toString(), offer.getInput().toString()}), false);
        }
    }
}

