/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import java.util.List;
import me.desht.pneumaticcraft.api.item.IProgrammable;
import me.desht.pneumaticcraft.client.gui.GuiSecurityStationHacking;
import me.desht.pneumaticcraft.common.core.ModItems;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class ItemNetworkComponent
extends Item
implements IProgrammable {
    private final NetworkComponentType type;

    public ItemNetworkComponent(NetworkComponentType type) {
        super(ModItems.defaultProps());
        this.type = type;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> curInfo, ITooltipFlag extraInfo) {
        super.func_77624_a(stack, worldIn, curInfo, extraInfo);
        if (worldIn != null && worldIn.field_72995_K) {
            GuiSecurityStationHacking.addExtraHackInfoStatic(curInfo);
        }
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        if (!entity.func_130014_f_().field_72995_K && this.canProgram(stack) && stack.func_77942_o() && stack.func_77978_p().func_74764_b("pneumaticcraft:progWidgets")) {
            entity.func_174873_u();
        }
        return false;
    }

    @Override
    public boolean canProgram(ItemStack stack) {
        return this.type == NetworkComponentType.NETWORK_API || this.type == NetworkComponentType.NETWORK_DATA_STORAGE;
    }

    @Override
    public boolean usesPieces(ItemStack stack) {
        return this.type == NetworkComponentType.NETWORK_API;
    }

    @Override
    public boolean showProgramTooltip() {
        return true;
    }

    public static NetworkComponentType getType(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemNetworkComponent ? ((ItemNetworkComponent)stack.func_77973_b()).type : null;
    }

    public static enum NetworkComponentType {
        DIAGNOSTIC_SUBROUTINE("diagnostic_subroutine", true),
        NETWORK_API("network_api", false),
        NETWORK_DATA_STORAGE("network_data_storage", false),
        NETWORK_IO_PORT("network_io_port", true),
        NETWORK_REGISTRY("network_registry", true),
        NETWORK_NODE("network_node", true);

        private final String name;
        private final boolean secStationComponent;

        private NetworkComponentType(String name, boolean secStationComponent) {
            this.name = name;
            this.secStationComponent = secStationComponent;
        }

        public boolean isSecStationComponent() {
            return this.secStationComponent;
        }

        public String getRegistryName() {
            return this.name;
        }
    }
}

