/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.inventory;

import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.common.core.ModContainers;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.inventory.ContainerPneumaticBase;
import me.desht.pneumaticcraft.common.item.ItemDrillBit;
import me.desht.pneumaticcraft.common.item.ItemJackHammer;
import me.desht.pneumaticcraft.common.tileentity.TileEntityBase;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class ContainerJackhammerSetup
extends ContainerPneumaticBase<TileEntityBase> {
    private final ItemJackHammer.DrillBitHandler drillBitHandler;
    private final ItemJackHammer.EnchantmentHandler enchantmentHandler;
    private final Hand hand;

    public ContainerJackhammerSetup(int windowId, PlayerInventory invPlayer, PacketBuffer buffer) {
        this(windowId, invPlayer, ContainerJackhammerSetup.getHand(buffer));
    }

    public ContainerJackhammerSetup(int windowId, PlayerInventory invPlayer, Hand hand) {
        super((ContainerType)ModContainers.JACKHAMMER_SETUP.get(), windowId, invPlayer);
        this.hand = hand;
        this.drillBitHandler = ItemJackHammer.getDrillBitHandler(invPlayer.field_70458_d.func_184586_b(hand));
        if (this.drillBitHandler != null) {
            this.func_75146_a((Slot)new SlotDrillBit(this.drillBitHandler, 0, 128, 19));
        }
        this.enchantmentHandler = ItemJackHammer.getEnchantmentHandler(invPlayer.field_70458_d.func_184586_b(hand));
        if (this.enchantmentHandler != null) {
            this.func_75146_a((Slot)new SlotEnchantmentHandler(this.enchantmentHandler, 0, 96, 19));
        }
        this.addPlayerSlots(invPlayer, 100);
    }

    public void func_75134_a(PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
        this.drillBitHandler.save();
        this.enchantmentHandler.save();
    }

    @Override
    public boolean func_75145_c(PlayerEntity player) {
        return player.func_184586_b(this.hand).func_77973_b() == ModItems.JACKHAMMER.get();
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayerEntity player) {
        ItemStack hammerStack = player.func_184586_b(this.hand);
        if (tag.startsWith("digmode:") && hammerStack.func_77973_b() instanceof ItemJackHammer) {
            try {
                ItemDrillBit.DrillBitType bitType = ((ItemJackHammer)hammerStack.func_77973_b()).getDrillBit(hammerStack);
                ItemJackHammer.DigMode dt = ItemJackHammer.DigMode.valueOf(tag.substring(8));
                if (dt.getBitType().getTier() <= bitType.getTier() || dt == ItemJackHammer.DigMode.MODE_1X1) {
                    ItemJackHammer.setDigMode(hammerStack, dt);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public Hand getHand() {
        return this.hand;
    }

    private static class SlotEnchantmentHandler
    extends SlotItemHandler {
        public SlotEnchantmentHandler(ItemJackHammer.EnchantmentHandler itemHandler, int index, int xPosition, int yPosition) {
            super((IItemHandler)itemHandler, index, xPosition, yPosition);
        }

        public boolean func_75214_a(@Nonnull ItemStack stack) {
            return ItemJackHammer.EnchantmentHandler.validateBook(stack);
        }

        public void func_75220_a(@Nonnull ItemStack oldStackIn, @Nonnull ItemStack newStackIn) {
            ((ItemJackHammer.EnchantmentHandler)this.getItemHandler()).save();
        }

        public void func_75218_e() {
            ((ItemJackHammer.EnchantmentHandler)this.getItemHandler()).save();
        }
    }

    private static class SlotDrillBit
    extends SlotItemHandler {
        public SlotDrillBit(ItemJackHammer.DrillBitHandler itemHandler, int index, int xPosition, int yPosition) {
            super((IItemHandler)itemHandler, index, xPosition, yPosition);
        }

        public boolean func_75214_a(@Nonnull ItemStack stack) {
            return stack.func_77973_b() instanceof ItemDrillBit;
        }

        public void func_75218_e() {
            ((ItemJackHammer.DrillBitHandler)this.getItemHandler()).save();
        }

        public void func_75220_a(@Nonnull ItemStack oldStackIn, @Nonnull ItemStack newStackIn) {
            ((ItemJackHammer.DrillBitHandler)this.getItemHandler()).save();
        }
    }
}

