/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.hacking.secstation;

import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.common.hacking.secstation.ISimulationController;
import me.desht.pneumaticcraft.common.item.ItemNetworkComponent;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.SoundEvents;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class HackSimulation {
    public static final int GRID_WIDTH = 5;
    public static final int GRID_HEIGHT = 7;
    public static final int GRID_SIZE = 35;
    private static final List<List<Integer>> connectionMatrix = new ArrayList<List<Integer>>();
    public static final int NODE_FORTIFICATION_TIME = 100;
    private final Node[] nodes = new Node[35];
    private ISimulationController controller;
    private final int startPosition;
    private boolean isStarted = false;
    private boolean hackComplete = false;
    private final float baseBridgeSpeed;
    private final ISimulationController.HackingSide side;
    private int pendingNukePos = -1;
    private final List<ItemNetworkComponent.NetworkComponentType> targets = new ArrayList<ItemNetworkComponent.NetworkComponentType>();
    public final List<ConnectionEntry> allConnections = new ArrayList<ConnectionEntry>();
    private boolean awake;
    private int stopWormTimer;
    private int nukeVirusCooldown;

    public HackSimulation(ISimulationController controller, int startPosition, float baseBridgeSpeed, ISimulationController.HackingSide side) {
        this.controller = controller;
        this.startPosition = startPosition;
        this.baseBridgeSpeed = baseBridgeSpeed;
        this.side = side;
        if (side == ISimulationController.HackingSide.PLAYER) {
            this.awake = true;
            this.targets.add(ItemNetworkComponent.NetworkComponentType.DIAGNOSTIC_SUBROUTINE);
            this.targets.add(ItemNetworkComponent.NetworkComponentType.NETWORK_REGISTRY);
        } else {
            this.awake = false;
            this.targets.add(ItemNetworkComponent.NetworkComponentType.NETWORK_IO_PORT);
        }
        this.stopWormTimer = 0;
    }

    public static HackSimulation dummySimulation() {
        return new HackSimulation(null, -1, 0.03f, ISimulationController.HackingSide.AI);
    }

    public static HackSimulation readFromNetwork(PacketBuffer buffer) {
        float speed = buffer.readFloat();
        ISimulationController.HackingSide side = buffer.readBoolean() ? ISimulationController.HackingSide.AI : ISimulationController.HackingSide.PLAYER;
        int start = buffer.func_150792_a();
        return new HackSimulation(null, start, speed, side);
    }

    public void writeToNetwork(PacketBuffer buffer) {
        buffer.writeFloat(this.baseBridgeSpeed);
        buffer.writeBoolean(this.side == ISimulationController.HackingSide.AI);
        buffer.func_150787_b(this.startPosition);
    }

    public void addNode(int position, ItemNetworkComponent.NetworkComponentType type, int count) {
        if (type == null || count == 0) {
            return;
        }
        Validate.isTrue((!this.isStarted ? 1 : 0) != 0, (String)"can't add nodes after simulation has started!", (Object[])new Object[0]);
        Validate.isTrue((this.nodes[position] == null ? 1 : 0) != 0, (String)("position " + position + " already has a node!"), (Object[])new Object[0]);
        this.nodes[position] = new Node(type, count);
        if (this.isDummy() || position == this.startPosition) {
            Validate.isTrue((this.startPosition == -1 || !this.targets.contains((Object)type) ? 1 : 0) != 0, (String)("start node may not be of target type " + (Object)((Object)type)), (Object[])new Object[0]);
            this.nodes[position].setHackProgress(position, 1.0f, false);
        }
    }

    public void addNode(int slot, ItemStack stack) {
        this.addNode(slot, ItemNetworkComponent.getType(stack), this.controller == null ? 1 : stack.func_190916_E());
    }

    private boolean isDummy() {
        return this.startPosition < 0;
    }

    public Node getNodeAt(int pos) {
        return this.nodes[pos];
    }

    public boolean isHackComplete() {
        return this.hackComplete;
    }

    HackSimulation setController(ISimulationController controller) {
        this.controller = controller;
        return this;
    }

    public boolean isNukeVirusReady() {
        return this.nukeVirusCooldown == 0;
    }

    public ISimulationController.HackingSide getSide() {
        return this.side;
    }

    public void tick() {
        if (this.hackComplete) {
            return;
        }
        this.isStarted = true;
        if (this.stopWormTimer > 0) {
            --this.stopWormTimer;
        }
        if (this.nukeVirusCooldown > 0) {
            --this.nukeVirusCooldown;
        }
        this.allConnections.clear();
        int nonNullNodes = 0;
        int completeNodes = 0;
        for (int i = 0; i < this.nodes.length; ++i) {
            Node node = this.getNodeAt(i);
            if (node == null) continue;
            ++nonNullNodes;
            int f = node.fortification;
            node.tick();
            if (this.controller != null && f < 100 && node.fortification == 100) {
                this.controller.onNodeFortified(this, i);
            }
            if (this.side == ISimulationController.HackingSide.AI && this.isAwake() && (this.isDummy() || node.isHacked()) && node.outGoingHacks.isEmpty()) {
                for (int neighbourPos : this.getNeighbours(i)) {
                    Node neighbourNode = this.getNodeAt(neighbourPos);
                    if (neighbourNode == null || !this.isDummy() && neighbourNode.isHacked()) continue;
                    node.startHacking(i, neighbourPos);
                }
            }
            if (this.pendingNukePos == i) {
                this.activateNukeVirus(i);
            }
            int finishedConns = 0;
            for (Pair conn : node.outGoingHacks) {
                if (((Float)conn.getValue()).floatValue() < 1.0f) {
                    if (this.stopWormTimer == 0) {
                        Node targetNode = this.getNodeAt((Integer)conn.getKey());
                        conn.setValue((Object)Float.valueOf(Math.min(1.0f, ((Float)conn.getValue()).floatValue() + targetNode.getProgressPerTick())));
                        targetNode.setHackProgress((Integer)conn.getKey(), ((Float)conn.getValue()).floatValue(), true);
                    }
                } else {
                    ++finishedConns;
                }
                this.allConnections.add(new ConnectionEntry(i, (Integer)conn.getKey(), ((Float)conn.getValue()).floatValue()));
            }
            if (finishedConns != node.outGoingHacks.size() || node.outGoingHacks.isEmpty()) continue;
            ++completeNodes;
        }
        if (completeNodes >= nonNullNodes) {
            this.hackComplete = true;
        }
    }

    public void activateNukeVirus(int pos) {
        int neighbour = this.getHackedNeighbour(this.pendingNukePos);
        if (neighbour >= 0) {
            boolean found = false;
            for (Pair conn : this.getNodeAt(neighbour).outGoingHacks) {
                if ((Integer)conn.getLeft() != this.pendingNukePos) continue;
                conn.setValue((Object)Float.valueOf(1.0f));
                found = true;
            }
            if (!found) {
                this.getNodeAt(neighbour).outGoingHacks.add(Pair.of((Object)this.pendingNukePos, (Object)Float.valueOf(1.0f)));
            }
            this.getNodeAt(pos).setHackProgress(pos, 1.0f, false);
            if (this.controller != null) {
                this.controller.getHacker().func_184185_a(SoundEvents.field_187539_bB, 1.0f, 1.0f);
            }
            this.nukeVirusCooldown = 60;
        }
        this.pendingNukePos = -1;
    }

    public List<Integer> getNeighbours(int node) {
        return connectionMatrix.get(node);
    }

    public void startHack(int targetPos) {
        if (this.getNodeAt(targetPos).isHacked()) {
            return;
        }
        for (int neighbour : this.getNeighbours(targetPos)) {
            Node attacker = this.getNodeAt(neighbour);
            if (attacker == null || !attacker.isHacked()) continue;
            attacker.startHacking(neighbour, targetPos);
            return;
        }
    }

    public boolean initiateNukeVirus(int pos) {
        Validate.isTrue((pos >= 0 && pos < 35 ? 1 : 0) != 0, (String)("nuke position " + pos + " out of range!"), (Object[])new Object[0]);
        if (this.pendingNukePos < 0 && this.isNukeVirusReady() && this.getNodeAt(pos).type != ItemNetworkComponent.NetworkComponentType.DIAGNOSTIC_SUBROUTINE && this.getNodeAt(pos).type != ItemNetworkComponent.NetworkComponentType.NETWORK_REGISTRY) {
            this.pendingNukePos = pos;
            return true;
        }
        return false;
    }

    public void applyStopWorm(int duration) {
        this.stopWormTimer = duration;
    }

    public void fortify(int pos) {
        Node node = this.getNodeAt(pos);
        if (node != null) {
            node.startFortifying();
        }
    }

    public void wakeUp() {
        if (!this.awake) {
            this.awake = true;
            if (this.controller != null) {
                this.controller.getHacker().func_184185_a(SoundEvents.field_187603_D, 1.0f, 1.0f);
            }
        }
    }

    public boolean isAwake() {
        return this.awake;
    }

    public void setHackComplete() {
        this.hackComplete = true;
    }

    public void syncFromServer(List<ConnectionEntry> newConns) {
        for (int i = 0; i < this.nodes.length; ++i) {
            Node node = this.getNodeAt(i);
            if (node == null) continue;
            node.outGoingHacks.clear();
        }
        newConns.forEach(conn -> this.getNodeAt(conn.from).outGoingHacks.add(MutablePair.of((Object)conn.to, (Object)Float.valueOf(conn.progress))));
    }

    public void updateFortification(List<Pair<Integer, Integer>> fortification) {
        fortification.forEach(pair -> this.getNodeAt((Integer)pair.getLeft()).fortification = (Integer)pair.getRight());
    }

    public long getRemainingTraceTime() {
        return 0L;
    }

    public int getHackedNeighbour(int nodePos) {
        for (int n2 : this.getNeighbours(nodePos)) {
            Node node2 = this.getNodeAt(n2);
            if (node2 == null || !node2.isHacked()) continue;
            return n2;
        }
        return -1;
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    public boolean isStopWormed() {
        return this.stopWormTimer > 0;
    }

    static {
        for (int i = 0; i < 35; ++i) {
            int xPos = i % 5;
            int yPos = i / 5;
            ArrayList<Integer> conns = new ArrayList<Integer>();
            if (yPos > 0) {
                conns.add(i - 5);
                if (xPos > 0) {
                    conns.add(i - 6);
                }
                if (xPos < 4) {
                    conns.add(i - 4);
                }
            }
            if (yPos < 6) {
                conns.add(i + 5);
                if (xPos > 0) {
                    conns.add(i + 4);
                }
                if (xPos < 4) {
                    conns.add(i + 6);
                }
            }
            if (xPos > 0) {
                conns.add(i - 1);
            }
            if (xPos < 4) {
                conns.add(i + 1);
            }
            connectionMatrix.add(conns);
        }
    }

    public static class ConnectionEntry {
        public final int from;
        public final int to;
        public final float progress;

        ConnectionEntry(int from, int to, float progress) {
            this.from = from;
            this.to = to;
            this.progress = progress;
        }

        public void write(PacketBuffer buffer) {
            buffer.func_150787_b(this.from);
            buffer.func_150787_b(this.to);
            buffer.writeFloat(this.progress);
        }

        public static ConnectionEntry readFromNetwork(PacketBuffer buffer) {
            return new ConnectionEntry(buffer.func_150792_a(), buffer.func_150792_a(), buffer.readFloat());
        }
    }

    public class Node {
        private final ItemNetworkComponent.NetworkComponentType type;
        private final int size;
        private float hackProgress;
        private int fortification;
        private final List<Pair<Integer, Float>> outGoingHacks = new ArrayList<Pair<Integer, Float>>();

        Node(ItemNetworkComponent.NetworkComponentType type, int size) {
            this.type = type;
            this.size = size;
            this.hackProgress = 0.0f;
            this.fortification = 0;
        }

        public ItemNetworkComponent.NetworkComponentType getType() {
            return this.type;
        }

        public int getSize() {
            return this.size;
        }

        public void startFortifying() {
            if (this.fortification == 0) {
                this.fortification = 1;
            }
        }

        public boolean isFortified() {
            return this.fortification >= 100;
        }

        public float getHackProgress() {
            return this.hackProgress;
        }

        public void setHackProgress(int pos, float hackProgress, boolean notifyController) {
            boolean wasHacked = this.isHacked();
            this.hackProgress = hackProgress;
            if (HackSimulation.this.controller != null && this.isHacked() && !wasHacked) {
                if (HackSimulation.this.isStarted) {
                    if (HackSimulation.this.side == ISimulationController.HackingSide.AI && HackSimulation.this.isAwake()) {
                        HackSimulation.this.controller.getHacker().func_184185_a(SoundEvents.field_187676_dE, 1.0f, 1.0f);
                    } else if (HackSimulation.this.side == ISimulationController.HackingSide.PLAYER) {
                        HackSimulation.this.controller.getHacker().func_184185_a(SoundEvents.field_193809_ey, 1.0f, 1.0f);
                    }
                }
                if (notifyController) {
                    HackSimulation.this.controller.onNodeHacked(HackSimulation.this, pos);
                }
                if (HackSimulation.this.isStarted && HackSimulation.this.targets.contains((Object)this.type)) {
                    HackSimulation.this.hackComplete = true;
                }
            }
        }

        public boolean isHacked() {
            return this.hackProgress >= 1.0f;
        }

        void startHacking(int fromPos, int toPos) {
            this.outGoingHacks.add((Pair<Integer, Float>)MutablePair.of((Object)toPos, (Object)Float.valueOf(0.0f)));
            if (HackSimulation.this.controller != null) {
                HackSimulation.this.controller.onConnectionStarted(HackSimulation.this, fromPos, toPos, 0.0f);
            }
        }

        float getProgressPerTick() {
            return HackSimulation.this.baseBridgeSpeed * (1.0f / (1.2f * (float)(this.size + (this.isFortified() ? 1 : 0))));
        }

        public void tick() {
            if (this.fortification > 0 && this.fortification < 100) {
                ++this.fortification;
            }
        }

        public int getFortification() {
            return this.fortification;
        }

        public float getFortificationProgress() {
            return (float)this.fortification / 100.0f;
        }
    }
}

