/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.tubes;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import me.desht.pneumaticcraft.common.block.tubes.INetworkedModule;
import me.desht.pneumaticcraft.common.block.tubes.TubeModule;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPressureTube;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class ModuleNetworkManager {
    private static final Map<ResourceLocation, ModuleNetworkManager> INSTANCES = new HashMap<ResourceLocation, ModuleNetworkManager>();
    private final Map<TubeModule, Set<TubeModule>> connectionCache = new HashMap<TubeModule, Set<TubeModule>>();
    private boolean needInvalidate = false;

    public static ModuleNetworkManager getInstance(World w) {
        return INSTANCES.computeIfAbsent(w.func_234923_W_().func_240901_a_(), dimId -> new ModuleNetworkManager());
    }

    Set<TubeModule> getConnectedModules(TubeModule module) {
        if (this.needInvalidate) {
            this.connectionCache.clear();
            this.needInvalidate = false;
        }
        return this.connectionCache.computeIfAbsent(module, this::computeConnections);
    }

    public void invalidateCache() {
        this.needInvalidate = true;
    }

    private Set<TubeModule> computeConnections(TubeModule module) {
        HashSet<TubeModule> modules = new HashSet<TubeModule>();
        HashSet<TileEntity> traversedTubes = new HashSet<TileEntity>();
        Stack<TileEntityPressureTube> pendingTubes = new Stack<TileEntityPressureTube>();
        pendingTubes.push(module.getTube());
        while (!pendingTubes.isEmpty()) {
            TileEntityPressureTube tube = (TileEntityPressureTube)pendingTubes.pop();
            tube.tubeModules().filter(tm -> tm instanceof INetworkedModule && module.getClass() == tm.getClass()).forEach(modules::add);
            for (Direction dir : DirectionUtil.VALUES) {
                TileEntity newTube = tube.getConnectedNeighbor(dir);
                if (!(newTube instanceof TileEntityPressureTube) || traversedTubes.contains(newTube)) continue;
                pendingTubes.add((TileEntityPressureTube)newTube);
                traversedTubes.add(newTube);
            }
        }
        return modules;
    }
}

