/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.ai;

import java.util.HashSet;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.api.semiblock.ISemiBlock;
import me.desht.pneumaticcraft.common.ai.DroneAILiquidExport;
import me.desht.pneumaticcraft.common.ai.DroneAILiquidImport;
import me.desht.pneumaticcraft.common.ai.DroneEntityAIInventoryExport;
import me.desht.pneumaticcraft.common.ai.DroneEntityAIInventoryImport;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.ai.LogisticsManager;
import me.desht.pneumaticcraft.common.core.ModProgWidgets;
import me.desht.pneumaticcraft.common.entity.semiblock.EntityLogisticsFrame;
import me.desht.pneumaticcraft.common.progwidgets.ILiquidExport;
import me.desht.pneumaticcraft.common.progwidgets.ILiquidFiltered;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetAreaItemBase;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetInventoryBase;
import me.desht.pneumaticcraft.common.semiblock.SemiblockTracker;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.StreamUtils;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;

public class DroneAILogistics
extends Goal {
    private Goal curAI;
    private final IDroneBase drone;
    private final ProgWidgetAreaItemBase widget;
    private LogisticsManager.LogisticsTask curTask;

    public DroneAILogistics(IDroneBase drone, ProgWidgetAreaItemBase widget) {
        this.drone = drone;
        this.widget = widget;
    }

    private LogisticsManager getLogisticsManager() {
        Set<BlockPos> area;
        if (this.drone.getLogisticsManager() == null && !(area = this.widget.getCachedAreaSet()).isEmpty()) {
            AxisAlignedBB aabb = this.widget.getAreaExtents();
            Stream<ISemiBlock> semiBlocksInArea = SemiblockTracker.getInstance().getSemiblocksInArea(this.drone.world(), aabb);
            Stream<ISemiBlock> logisticFrames = StreamUtils.ofType(EntityLogisticsFrame.class, semiBlocksInArea);
            LogisticsManager manager = new LogisticsManager();
            logisticFrames.filter(frame -> area.contains(frame.getBlockPos())).forEach(manager::addLogisticFrame);
            this.drone.setLogisticsManager(manager);
        }
        return this.drone.getLogisticsManager();
    }

    public boolean func_75250_a() {
        if (this.getLogisticsManager() == null) {
            return false;
        }
        this.curTask = null;
        return this.doLogistics();
    }

    private boolean doLogistics() {
        ItemStack item = this.drone.getInv().getStackInSlot(0);
        FluidStack fluid = this.drone.getFluidTank().getFluid();
        PriorityQueue<LogisticsManager.LogisticsTask> tasks = this.getLogisticsManager().getTasks(item.func_190926_b() ? fluid : item, true);
        if (tasks.size() > 0) {
            this.curTask = tasks.poll();
            return this.execute(this.curTask);
        }
        return false;
    }

    public boolean func_75253_b() {
        if (this.curTask == null) {
            return false;
        }
        if (!this.curAI.func_75253_b()) {
            if (this.curAI instanceof DroneEntityAIInventoryImport) {
                this.curTask.requester.clearIncomingStack(this.curTask.transportingItem);
                return this.clearAIAndProvideAgain();
            }
            if (this.curAI instanceof DroneAILiquidImport) {
                this.curTask.requester.clearIncomingStack(this.curTask.transportingFluid);
                return this.clearAIAndProvideAgain();
            }
            this.curAI = null;
            return false;
        }
        this.curTask.informRequester();
        return true;
    }

    private boolean clearAIAndProvideAgain() {
        this.curAI = null;
        if (this.curTask.isStillValid(this.drone.getInv().getStackInSlot(0).func_190926_b() ? this.drone.getFluidTank().getFluid() : this.drone.getInv().getStackInSlot(0)) && this.execute(this.curTask)) {
            return true;
        }
        this.curTask = null;
        return this.doLogistics();
    }

    public boolean execute(LogisticsManager.LogisticsTask task) {
        if (!this.drone.getInv().getStackInSlot(0).func_190926_b() && !task.transportingItem.func_190926_b()) {
            if (this.hasNoPathTo(task.requester.getBlockPos())) {
                return false;
            }
            this.curAI = new DroneEntityAIInventoryExport(this.drone, new FakeWidgetLogistics(task.requester.getBlockPos(), task.requester.getSide(), task.transportingItem));
        } else if (this.drone.getFluidTank().getFluidAmount() > 0 && !task.transportingFluid.isEmpty()) {
            if (this.hasNoPathTo(task.requester.getBlockPos())) {
                return false;
            }
            this.curAI = new DroneAILiquidExport<FakeWidgetLogistics>(this.drone, new FakeWidgetLogistics(task.requester.getBlockPos(), task.requester.getSide(), task.transportingFluid));
        } else if (!task.transportingItem.func_190926_b()) {
            if (this.hasNoPathTo(task.provider.getBlockPos())) {
                return false;
            }
            this.curAI = new DroneEntityAIInventoryImport(this.drone, new FakeWidgetLogistics(task.provider.getBlockPos(), task.provider.getSide(), task.transportingItem));
        } else {
            if (this.hasNoPathTo(task.provider.getBlockPos())) {
                return false;
            }
            this.curAI = new DroneAILiquidImport<FakeWidgetLogistics>(this.drone, new FakeWidgetLogistics(task.provider.getBlockPos(), task.provider.getSide(), task.transportingFluid));
        }
        if (this.curAI.func_75250_a()) {
            task.informRequester();
            return true;
        }
        return false;
    }

    private boolean hasNoPathTo(BlockPos pos) {
        for (Direction d : DirectionUtil.VALUES) {
            if (!this.drone.isBlockValidPathfindBlock(pos.func_177972_a(d))) continue;
            return false;
        }
        this.drone.getDebugger().addEntry("pneumaticcraft.gui.progWidget.general.debug.cantNavigate", pos);
        return true;
    }

    private static class FakeWidgetLogistics
    extends ProgWidgetInventoryBase
    implements ILiquidFiltered,
    ILiquidExport {
        private final ItemStack stack;
        private final FluidStack fluid;
        private final Set<BlockPos> area;
        private final boolean[] sides = new boolean[6];

        FakeWidgetLogistics(BlockPos pos, Direction side, @Nonnull ItemStack stack) {
            super((ProgWidgetType)ModProgWidgets.LOGISTICS.get());
            this.stack = stack;
            this.fluid = FluidStack.EMPTY;
            this.area = new HashSet<BlockPos>();
            this.area.add(pos);
            this.sides[side.func_176745_a()] = true;
        }

        FakeWidgetLogistics(BlockPos pos, Direction side, FluidStack fluid) {
            super((ProgWidgetType)ModProgWidgets.LOGISTICS.get());
            this.stack = ItemStack.field_190927_a;
            this.fluid = fluid;
            this.area = new HashSet<BlockPos>();
            this.area.add(pos);
            this.sides[side.func_176745_a()] = true;
        }

        @Override
        public DyeColor getColor() {
            return DyeColor.WHITE;
        }

        @Override
        public void getArea(Set<BlockPos> area) {
            area.addAll(this.area);
        }

        @Override
        public void setSides(boolean[] sides) {
        }

        @Override
        public boolean[] getSides() {
            return this.sides;
        }

        @Override
        public boolean isItemValidForFilters(@Nonnull ItemStack item) {
            return !item.func_190926_b() && item.func_77969_a(this.stack);
        }

        @Override
        public ResourceLocation getTexture() {
            return null;
        }

        @Override
        public boolean useCount() {
            return true;
        }

        @Override
        public void setUseCount(boolean useCount) {
        }

        @Override
        public int getCount() {
            return !this.stack.func_190926_b() ? this.stack.func_190916_E() : this.fluid.getAmount();
        }

        @Override
        public void setCount(int count) {
        }

        @Override
        public boolean isFluidValid(Fluid fluid) {
            return fluid == this.fluid.getFluid();
        }

        @Override
        public void setPlaceFluidBlocks(boolean placeFluidBlocks) {
        }

        @Override
        public boolean isPlacingFluidBlocks() {
            return false;
        }
    }
}

