/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.desht.pneumaticcraft.api.client.IGuiAnimatedStat;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IArmorUpgradeClientHandler;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IGuiScreen;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IOptionPage;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.api.pneumatic_armor.ICommonArmorHandler;
import me.desht.pneumaticcraft.client.KeyHandler;
import me.desht.pneumaticcraft.client.gui.pneumatic_armor.option_screens.SearchOptions;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.render.ModRenderTypes;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.HUDHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.RenderSearchItemBlock;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.EntityTrackerClientHandler;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.config.subconfig.ArmorHUDLayout;
import me.desht.pneumaticcraft.common.item.ItemPneumaticArmor;
import me.desht.pneumaticcraft.common.item.ItemRegistry;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import me.desht.pneumaticcraft.common.pneumatic_armor.handlers.SearchHandler;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class SearchClientHandler
extends IArmorUpgradeClientHandler.AbstractHandler<SearchHandler> {
    private int totalSearchedItemCount;
    private int itemSearchCount;
    private int ticksExisted;
    private final Map<ItemEntity, Integer> searchedItems = new HashMap<ItemEntity, Integer>();
    private final Map<BlockPos, RenderSearchItemBlock> trackedInventories = new HashMap<BlockPos, RenderSearchItemBlock>();
    private IGuiAnimatedStat searchInfo;
    private ItemStack searchedStack = ItemStack.field_190927_a;

    public SearchClientHandler() {
        super(ArmorUpgradeRegistry.getInstance().searchHandler);
    }

    @Override
    public void tickClient(ICommonArmorHandler armorHandler) {
        ++this.ticksExisted;
        if ((this.ticksExisted & 0xF) == 0) {
            int blockSearchCount = this.trackInventoryCounts(armorHandler.getUpgradeCount(EquipmentSlotType.HEAD, EnumUpgrade.RANGE));
            this.searchedItems.entrySet().removeIf(e -> !((ItemEntity)e.getKey()).func_70089_S());
            this.totalSearchedItemCount = this.itemSearchCount + blockSearchCount;
        }
        Item item = ItemPneumaticArmor.getSearchedItem(ClientUtils.getWornArmor(EquipmentSlotType.HEAD));
        ArrayList<ITextComponent> textList = new ArrayList<ITextComponent>();
        if (item == null || item == Items.field_190931_a) {
            textList.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.armor.search.configure", I18n.func_135052_a((String)KeyHandler.getInstance().keybindOpenOptions.func_197982_m(), (Object[])new Object[0])));
        } else {
            if (this.searchedStack.func_77973_b() != item) {
                this.searchedStack = new ItemStack((IItemProvider)item);
            }
            textList.add((ITextComponent)this.searchedStack.func_200301_q().func_230532_e_().func_230529_a_((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.armor.search.found", this.totalSearchedItemCount)));
        }
        this.searchInfo.setText(textList);
    }

    @Override
    public void render3D(MatrixStack matrixStack, IRenderTypeBuffer buffer, float partialTicks) {
        IVertexBuilder builder = buffer.getBuffer(ModRenderTypes.getTextureRenderColored(Textures.GLOW_RESOURCE, true));
        this.searchedItems.forEach((item, value) -> {
            float height = MathHelper.func_76126_a((float)(((float)item.func_174872_o() + partialTicks) / 10.0f + item.field_70290_d)) * 0.1f + 0.2f;
            RenderSearchItemBlock.renderSearch(matrixStack, builder, item.field_70142_S + (item.func_226277_ct_() - item.field_70142_S) * (double)partialTicks, item.field_70137_T + (item.func_226278_cu_() - item.field_70137_T) * (double)partialTicks + (double)height, item.field_70136_U + (item.func_226281_cx_() - item.field_70136_U) * (double)partialTicks, value, this.totalSearchedItemCount, partialTicks);
        });
        this.trackedInventories.values().forEach(entry -> entry.renderSearchBlock(matrixStack, builder, this.totalSearchedItemCount, partialTicks));
    }

    @Override
    public void render2D(MatrixStack matrixStack, float partialTicks, boolean armorPieceHasPressure) {
    }

    private int trackInventoryCounts(int rangeUpgrades) {
        int blockSearchCount = 0;
        int blockTrackRange = 30 + Math.min(rangeUpgrades, 5) * 5;
        int blockTrackRangeSq = blockTrackRange * blockTrackRange;
        PlayerEntity player = ClientUtils.getClientPlayer();
        ArrayList<BlockPos> toRemove = new ArrayList<BlockPos>();
        for (Map.Entry<BlockPos, RenderSearchItemBlock> entry : this.trackedInventories.entrySet()) {
            int nItems;
            int n = nItems = entry.getKey().func_177951_i((Vector3i)player.func_233580_cy_()) < (double)blockTrackRangeSq ? entry.getValue().getSearchedItemCount() : 0;
            if (nItems == 0) {
                toRemove.add(entry.getKey());
            }
            blockSearchCount += nItems;
        }
        toRemove.forEach(this.trackedInventories::remove);
        return blockSearchCount;
    }

    void trackItemEntities(PlayerEntity player, int rangeUpgrades) {
        this.searchedItems.clear();
        this.itemSearchCount = 0;
        Item searchedItem = ItemPneumaticArmor.getSearchedItem(ClientUtils.getWornArmor(EquipmentSlotType.HEAD));
        if (searchedItem == null || searchedItem == Items.field_190931_a) {
            return;
        }
        List items = player.field_70170_p.func_217357_a(ItemEntity.class, EntityTrackerClientHandler.getAABBFromRange(player, rangeUpgrades));
        for (ItemEntity itemEntity : items) {
            if (itemEntity.func_92059_d().func_190926_b()) continue;
            if (itemEntity.func_92059_d().func_77973_b() == searchedItem) {
                this.searchedItems.put(itemEntity, itemEntity.func_92059_d().func_190916_E());
                this.itemSearchCount += itemEntity.func_92059_d().func_190916_E();
                continue;
            }
            List<ItemStack> inventoryItems = ItemRegistry.getInstance().getStacksInItem(itemEntity.func_92059_d());
            int itemCount = 0;
            for (ItemStack inventoryItem : inventoryItems) {
                if (inventoryItem.func_77973_b() != searchedItem) continue;
                itemCount += inventoryItem.func_190916_E();
            }
            if (itemCount <= 0) continue;
            this.searchedItems.put(itemEntity, itemCount);
            this.itemSearchCount += itemCount;
        }
    }

    void checkInventoryForItems(TileEntity te, Direction face, boolean handlerEnabled) {
        if (!handlerEnabled) {
            this.trackedInventories.clear();
        } else {
            Item searchedItem = ItemPneumaticArmor.getSearchedItem(ClientUtils.getWornArmor(EquipmentSlotType.HEAD));
            if (searchedItem != null) {
                te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, face).ifPresent(handler -> {
                    if (this.checkForItems((IItemHandler)handler, searchedItem)) {
                        this.trackedInventories.put(te.func_174877_v(), new RenderSearchItemBlock(te.func_145831_w(), te.func_174877_v()));
                    }
                });
            }
        }
    }

    private boolean checkForItems(IItemHandler handler, Item item) {
        for (int l = 0; l < handler.getSlots(); ++l) {
            int items;
            if (handler.getStackInSlot(l).func_190926_b() || (items = RenderSearchItemBlock.getSearchedItemCount(handler.getStackInSlot(l), item)) <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public void reset() {
        this.trackedInventories.clear();
        this.searchedItems.clear();
        this.ticksExisted = 0;
        this.searchInfo = null;
    }

    @Override
    public IOptionPage getGuiOptionsPage(IGuiScreen screen) {
        return new SearchOptions(screen, this);
    }

    @Override
    public IGuiAnimatedStat getAnimatedStat() {
        if (this.searchInfo == null) {
            WidgetAnimatedStat.StatIcon icon = WidgetAnimatedStat.StatIcon.of(EnumUpgrade.SEARCH.getItemStack());
            this.searchInfo = new WidgetAnimatedStat(null, (ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.armor.gui.search.searchingFor", new Object[0]), icon, HUDHandler.getInstance().getStatOverlayColor(), null, ArmorHUDLayout.INSTANCE.itemSearchStat);
            this.searchInfo.setMinimumContractedDimensions(0, 0);
        }
        return this.searchInfo;
    }

    @Override
    public void onResolutionChanged() {
        this.searchInfo = null;
    }
}

