/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pneumatic_armor.block_tracker;

import java.util.Collections;
import java.util.List;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IBlockTrackEntry;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.block_tracker.TrackerBlacklistManager;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.block.BlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;

public class BlockTrackEntryEnergy
implements IBlockTrackEntry {
    private static final ResourceLocation ID = PneumaticRegistry.RL("block_tracker.module.energy");

    @Override
    public boolean shouldTrackWithThisEntry(IBlockReader world, BlockPos pos, BlockState state, TileEntity te) {
        return te != null && !TrackerBlacklistManager.isEnergyBlacklisted(te) && IBlockTrackEntry.hasCapabilityOnAnyFace((ICapabilityProvider)te, CapabilityEnergy.ENERGY);
    }

    @Override
    public List<BlockPos> getServerUpdatePositions(TileEntity te) {
        return te == null ? Collections.emptyList() : Collections.singletonList(te.func_174877_v());
    }

    @Override
    public int spamThreshold() {
        return 8;
    }

    @Override
    public void addInformation(World world, BlockPos pos, TileEntity te, Direction face, List<ITextComponent> infoList) {
        try {
            infoList.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.blockTracker.info.rf", new Object[0]));
            te.getCapability(CapabilityEnergy.ENERGY, face).ifPresent(storage -> infoList.add((ITextComponent)new StringTextComponent(storage.getEnergyStored() + " / " + storage.getMaxEnergyStored() + " RF")));
        }
        catch (Throwable e) {
            TrackerBlacklistManager.addEnergyTEToBlacklist(te, e);
        }
    }

    @Override
    public ResourceLocation getEntryID() {
        return ID;
    }
}

