/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import me.desht.pneumaticcraft.client.model.entity.semiblocks.ModelHeatFrame;
import me.desht.pneumaticcraft.client.render.entity.RenderSemiblockBase;
import me.desht.pneumaticcraft.common.entity.semiblock.EntityHeatFrame;
import me.desht.pneumaticcraft.common.heat.TemperatureCategory;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.fml.client.registry.IRenderFactory;

public class RenderHeatFrame
extends RenderSemiblockBase<EntityHeatFrame> {
    public static final IRenderFactory<EntityHeatFrame> FACTORY = RenderHeatFrame::new;
    private static final ResourceLocation[] TEXTURES = new ResourceLocation[TemperatureCategory.values().length];
    private final ModelHeatFrame model = new ModelHeatFrame();

    private RenderHeatFrame(EntityRendererManager rendererManager) {
        super(rendererManager);
    }

    public void render(EntityHeatFrame entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        AxisAlignedBB aabb = entityIn.func_174813_aQ();
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227862_a_((float)aabb.func_216364_b(), (float)aabb.func_216360_c(), (float)aabb.func_216362_d());
        matrixStackIn.func_227861_a_(0.0, 1.5, 0.0);
        matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
        if (entityIn.getTimeSinceHit() > 0) {
            this.wobble(entityIn, partialTicks, matrixStackIn);
        }
        IVertexBuilder builder = bufferIn.getBuffer(RenderType.func_228638_b_((ResourceLocation)this.getTextureLocation(entityIn)));
        this.model.func_225598_a_(matrixStackIn, builder, this.kludgeLightingLevel(entityIn, packedLightIn), OverlayTexture.func_229200_a_((float)0.0f, (boolean)false), 0.0f, 0.0f, 0.0f, 1.0f);
        matrixStackIn.func_227865_b_();
    }

    public ResourceLocation getTextureLocation(EntityHeatFrame entityHeatFrame) {
        TemperatureCategory tc = TemperatureCategory.forTemperature(entityHeatFrame.getSyncedTemperature());
        return TEXTURES[tc.getIndex()];
    }

    static {
        for (TemperatureCategory tc : TemperatureCategory.values()) {
            RenderHeatFrame.TEXTURES[tc.getIndex()] = tc.getTextureName("heat_frame");
        }
    }
}

