/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.area;

import com.mojang.blaze3d.matrix.MatrixStack;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import me.desht.pneumaticcraft.api.item.IPositionProvider;
import me.desht.pneumaticcraft.client.pneumatic_armor.ArmorUpgradeClientRegistry;
import me.desht.pneumaticcraft.client.render.area.AreaRenderer;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.DroneDebugClientHandler;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.item.ItemCamoApplicator;
import me.desht.pneumaticcraft.common.item.ItemGPSAreaTool;
import me.desht.pneumaticcraft.common.item.ItemJackHammer;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import me.desht.pneumaticcraft.common.tileentity.ICamouflageableTE;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public enum AreaRenderManager {
    INSTANCE;

    private static final int MAX_DISPLAYED_POS = 15000;
    private final Map<BlockPos, AreaRenderer> showHandlers = new HashMap<BlockPos, AreaRenderer>();
    private World world;
    private DroneDebugClientHandler droneDebugger;
    private List<AreaRenderer> cachedPositionProviderShowers;
    private AreaRenderer camoPositionShower;
    private AreaRenderer jackhammerPositionShower;
    private LastJackhammerDetails lastJackhammerDetails = new LastJackhammerDetails(BlockPos.field_177992_a, null, null);
    private BlockPos lastPlayerPos;
    private int lastItemHashCode = 0;

    public static AreaRenderManager getInstance() {
        return INSTANCE;
    }

    @SubscribeEvent
    public void renderWorldLastEvent(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        IRenderTypeBuffer.Impl buffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        MatrixStack matrixStack = event.getMatrixStack();
        matrixStack.func_227860_a_();
        Vector3d projectedView = Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216785_c();
        matrixStack.func_227861_a_(-projectedView.field_72450_a, -projectedView.field_72448_b, -projectedView.field_72449_c);
        for (AreaRenderer handler : this.showHandlers.values()) {
            handler.render(matrixStack, (IRenderTypeBuffer)buffer);
        }
        this.maybeRenderPositionProvider(matrixStack, buffer, (PlayerEntity)player);
        this.maybeRenderCamo(matrixStack, buffer, (PlayerEntity)player);
        this.maybeRenderDroneDebug(matrixStack, buffer, (PlayerEntity)player);
        this.maybeRenderAreaTool(matrixStack, buffer, (PlayerEntity)player);
        this.maybeRenderJackhammer(matrixStack, buffer, (PlayerEntity)player);
        matrixStack.func_227865_b_();
    }

    @SubscribeEvent
    public void tickEnd(TickEvent.ClientTickEvent event) {
        PlayerEntity player = ClientUtils.getClientPlayer();
        if (player != null) {
            if (player.field_70170_p != this.world) {
                this.world = player.field_70170_p;
                this.showHandlers.clear();
            } else if (event.phase == TickEvent.Phase.END) {
                this.showHandlers.keySet().removeIf(pos -> PneumaticCraftUtils.distBetweenSq(pos, player.func_233580_cy_()) < 1024.0 && this.world.func_175623_d(pos));
            }
        }
    }

    private void maybeRenderAreaTool(MatrixStack matrixStack, IRenderTypeBuffer.Impl buffer, PlayerEntity player) {
        ItemStack curItem = this.getHeldPositionProvider(player);
        if (curItem.func_77973_b() instanceof ItemGPSAreaTool) {
            BlockPos p1 = ItemGPSAreaTool.getGPSLocation(player.func_130014_f_(), curItem, 0);
            BlockPos p2 = ItemGPSAreaTool.getGPSLocation(player.func_130014_f_(), curItem, 1);
            AreaRenderer.builder().withColor(-2130747296).xray().build(p1).render(matrixStack, (IRenderTypeBuffer)buffer);
            AreaRenderer.builder().withColor(-2141126816).xray().build(p2).render(matrixStack, (IRenderTypeBuffer)buffer);
        }
    }

    private void maybeRenderDroneDebug(MatrixStack matrixStack, IRenderTypeBuffer.Impl buffer, PlayerEntity player) {
        ItemStack helmet = player.func_184582_a(EquipmentSlotType.HEAD);
        if (helmet.func_77973_b() == ModItems.PNEUMATIC_HELMET.get()) {
            if (this.droneDebugger == null) {
                this.droneDebugger = ArmorUpgradeClientRegistry.getInstance().getClientHandler(ArmorUpgradeRegistry.getInstance().droneDebugHandler, DroneDebugClientHandler.class);
            }
            Set<BlockPos> posSet = this.droneDebugger.getShowingPositions();
            Set<BlockPos> areaSet = this.droneDebugger.getShownArea();
            AreaRenderer.builder().withColor(-1862336512).xray().build(posSet).render(matrixStack, (IRenderTypeBuffer)buffer);
            AreaRenderer.builder().withColor(1078001568).xray().build(areaSet).render(matrixStack, (IRenderTypeBuffer)buffer);
        }
    }

    private ItemStack getHeldPositionProvider(PlayerEntity player) {
        if (player.func_184614_ca().func_77973_b() instanceof IPositionProvider) {
            return player.func_184614_ca();
        }
        if (player.func_184592_cb().func_77973_b() instanceof IPositionProvider) {
            return player.func_184592_cb();
        }
        return ItemStack.field_190927_a;
    }

    private void maybeRenderPositionProvider(MatrixStack matrixStack, IRenderTypeBuffer.Impl buffer, PlayerEntity player) {
        ItemStack curItem = this.getHeldPositionProvider(player);
        if (curItem.func_77973_b() instanceof IPositionProvider && curItem.func_77942_o()) {
            int thisHash = curItem.func_77978_p().hashCode();
            if (thisHash != this.lastItemHashCode) {
                this.lastItemHashCode = thisHash;
                IPositionProvider positionProvider = (IPositionProvider)curItem.func_77973_b();
                List<BlockPos> posList = positionProvider.getStoredPositions(player.func_130014_f_(), curItem);
                if (posList.size() > 15000) {
                    posList.sort(Comparator.comparingDouble(blockPos -> blockPos.func_177951_i((Vector3i)player.func_233580_cy_())));
                    player.func_146105_b((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.message.gps_tool.culledRenderArea", posList.size()).func_240699_a_(TextFormatting.GOLD), false);
                }
                Int2ObjectOpenHashMap colorsToPositions = new Int2ObjectOpenHashMap();
                int n = Math.min(posList.size(), 15000);
                for (int i = 0; i < n; ++i) {
                    int renderColor = positionProvider.getRenderColor(i);
                    if (posList.get(i) == null || renderColor == 0) continue;
                    HashSet<BlockPos> positionsForColor = (HashSet<BlockPos>)colorsToPositions.get(renderColor);
                    if (positionsForColor == null) {
                        positionsForColor = new HashSet<BlockPos>();
                        colorsToPositions.put(renderColor, positionsForColor);
                    }
                    positionsForColor.add(posList.get(i));
                }
                this.cachedPositionProviderShowers = new ArrayList<AreaRenderer>(colorsToPositions.size());
                colorsToPositions.int2ObjectEntrySet().forEach(entry -> {
                    AreaRenderer.Builder builder = AreaRenderer.builder().withColor(entry.getIntKey());
                    if (positionProvider.disableDepthTest()) {
                        builder.xray();
                    }
                    this.cachedPositionProviderShowers.add(builder.build((Set)entry.getValue()));
                });
            }
            this.cachedPositionProviderShowers.forEach(renderer -> renderer.render(matrixStack, (IRenderTypeBuffer)buffer));
        }
    }

    private void maybeRenderCamo(MatrixStack matrixStack, IRenderTypeBuffer.Impl buffer, PlayerEntity player) {
        if (!(player.func_184614_ca().func_77973_b() instanceof ItemCamoApplicator)) {
            return;
        }
        if (this.lastPlayerPos == null || this.camoPositionShower == null || player.func_70092_e((double)this.lastPlayerPos.func_177958_n(), (double)this.lastPlayerPos.func_177956_o(), (double)this.lastPlayerPos.func_177952_p()) > 9.0) {
            this.lastPlayerPos = player.func_233580_cy_();
            Set<BlockPos> s = Minecraft.func_71410_x().field_71441_e.field_147482_g.stream().filter(te -> te instanceof ICamouflageableTE && te.func_174877_v().func_177951_i((Vector3i)this.lastPlayerPos) < 144.0).map(TileEntity::func_174877_v).collect(Collectors.toSet());
            this.camoPositionShower = AreaRenderer.builder().withColor(1082163455).withSize(0.75f).xray().drawShapes().build(s);
        }
        if (this.camoPositionShower != null) {
            this.camoPositionShower.render(matrixStack, (IRenderTypeBuffer)buffer);
        }
    }

    private void maybeRenderJackhammer(MatrixStack matrixStack, IRenderTypeBuffer.Impl buffer, PlayerEntity player) {
        if (this.world == null || !(player.func_184614_ca().func_77973_b() instanceof ItemJackHammer) || !(Minecraft.func_71410_x().field_71476_x instanceof BlockRayTraceResult)) {
            return;
        }
        ItemJackHammer.DigMode digMode = ItemJackHammer.getDigMode(player.func_184614_ca());
        if (digMode == ItemJackHammer.DigMode.MODE_1X1) {
            return;
        }
        BlockRayTraceResult brtr = (BlockRayTraceResult)Minecraft.func_71410_x().field_71476_x;
        if (!this.world.isAreaLoaded(brtr.func_216350_a(), 1) || this.world.func_180495_p(brtr.func_216350_a()).isAir((IBlockReader)this.world, brtr.func_216350_a())) {
            return;
        }
        if (!this.lastJackhammerDetails.matches(brtr.func_216350_a(), brtr.func_216354_b(), digMode)) {
            Set<BlockPos> posSet;
            BlockState state = this.world.func_180495_p(brtr.func_216350_a());
            Set<BlockPos> set = posSet = this.world.func_175625_s(brtr.func_216350_a()) == null && !(state.func_177230_c() instanceof FlowingFluidBlock) ? ItemJackHammer.getBreakPositions(this.world, brtr.func_216350_a(), brtr.func_216354_b(), player.func_174811_aO(), digMode) : Collections.emptySet();
            if (!posSet.isEmpty()) {
                posSet.add(brtr.func_216350_a());
            }
            AreaRenderer.Builder b = AreaRenderer.builder().withColor(0x20FFFFFF).withSize(1.01f).disableWriteMask();
            if (state.func_196954_c((IBlockReader)this.world, brtr.func_216350_a()) != VoxelShapes.func_197868_b()) {
                b = b.drawShapes();
            }
            this.jackhammerPositionShower = b.build(posSet);
            this.lastJackhammerDetails = new LastJackhammerDetails(brtr.func_216350_a(), brtr.func_216354_b(), digMode);
        }
        this.jackhammerPositionShower.render(matrixStack, (IRenderTypeBuffer)buffer);
    }

    public AreaRenderer showArea(BlockPos[] area, int color, TileEntity areaShower) {
        return this.showArea(new HashSet<BlockPos>(Arrays.asList(area)), color, areaShower);
    }

    public AreaRenderer showArea(Set<BlockPos> area, int color, TileEntity areaShower, boolean depth) {
        if (areaShower == null) {
            return null;
        }
        this.removeHandlers(areaShower);
        AreaRenderer.Builder builder = AreaRenderer.builder().withColor(color);
        if (depth) {
            builder.xray();
        }
        AreaRenderer handler = builder.build(area);
        this.showHandlers.put(new BlockPos(areaShower.func_174877_v().func_177958_n(), areaShower.func_174877_v().func_177956_o(), areaShower.func_174877_v().func_177952_p()), handler);
        return handler;
    }

    public AreaRenderer showArea(Set<BlockPos> area, int color, TileEntity areaShower) {
        return this.showArea(area, color, areaShower, true);
    }

    public boolean isShowing(TileEntity te) {
        return this.showHandlers.containsKey(new BlockPos(te.func_174877_v().func_177958_n(), te.func_174877_v().func_177956_o(), te.func_174877_v().func_177952_p()));
    }

    public void removeHandlers(TileEntity te) {
        this.showHandlers.remove(new BlockPos(te.func_174877_v().func_177958_n(), te.func_174877_v().func_177956_o(), te.func_174877_v().func_177952_p()));
    }

    public void clearPosProviderCache() {
        this.lastItemHashCode = 0;
    }

    private static class LastJackhammerDetails {
        private final BlockPos pos;
        private final Direction face;
        private final ItemJackHammer.DigMode digMode;

        private LastJackhammerDetails(BlockPos pos, Direction face, ItemJackHammer.DigMode digMode) {
            this.pos = pos;
            this.face = face;
            this.digMode = digMode;
        }

        private boolean matches(BlockPos pos, Direction face, ItemJackHammer.DigMode digMode) {
            return face == this.face && digMode == this.digMode && pos.equals((Object)this.pos);
        }
    }
}

