/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticContainerBase;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetLabel;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.inventory.ContainerPressureChamberInterface;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPressureChamberInterface;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class GuiPressureChamberInterface
extends GuiPneumaticContainerBase<ContainerPressureChamberInterface, TileEntityPressureChamberInterface> {
    private WidgetAnimatedStat statusStat;
    private WidgetButtonExtended exportAnyButton;
    private WidgetLabel exportTypeLabel;
    private boolean hasEnoughPressure = true;

    public GuiPressureChamberInterface(ContainerPressureChamberInterface container, PlayerInventory inv, ITextComponent displayString) {
        super(container, inv, displayString);
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.statusStat = this.addAnimatedStat((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.pressureChamberInterface.status", new Object[0]), new ItemStack((IItemProvider)ModBlocks.PRESSURE_CHAMBER_INTERFACE.get()), -22016, false);
        this.exportAnyButton = this.func_230480_a_(new WidgetButtonExtended(this.field_147003_i + 111, this.field_147009_r + 32, 60, 20, StringTextComponent.field_240750_d_).withTag("export_mode"));
        this.exportTypeLabel = this.func_230480_a_(new WidgetLabel(this.field_147003_i + 111, this.field_147009_r + 20, (ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.pressureChamberInterface.exportLabel", new Object[0])));
    }

    @Override
    protected void func_230451_b_(MatrixStack matrixStack, int x, int y) {
        super.func_230451_b_(matrixStack, x, y);
        int inputShift = (int)((1.0f - (float)Math.cos((double)(((TileEntityPressureChamberInterface)this.te).inputProgress / 40.0f) * Math.PI)) * 11.0f);
        int outputShift = (int)((1.0f - (float)Math.cos((double)(((TileEntityPressureChamberInterface)this.te).outputProgress / 40.0f) * Math.PI)) * 11.0f);
        GuiPressureChamberInterface.func_238467_a_((MatrixStack)matrixStack, (int)(63 + inputShift), (int)30, (int)(87 + inputShift), (int)32, (int)-10853633);
        GuiPressureChamberInterface.func_238467_a_((MatrixStack)matrixStack, (int)(63 + outputShift), (int)54, (int)(87 + outputShift), (int)56, (int)-22528);
    }

    @Override
    protected PointXY getInvNameOffset() {
        return new PointXY(0, -2);
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_PRESSURE_CHAMBER_INTERFACE;
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        boolean exporting = ((TileEntityPressureChamberInterface)this.te).interfaceMode == TileEntityPressureChamberInterface.InterfaceDirection.EXPORT;
        this.exportAnyButton.setVisible(exporting);
        this.exportAnyButton.field_230694_p_ = exporting;
        this.exportTypeLabel.field_230694_p_ = exporting;
        if (this.exportAnyButton.field_230694_p_) {
            String textKey = "pneumaticcraft.gui.pressureChamberInterface.export." + (((TileEntityPressureChamberInterface)this.te).exportAny ? "any" : "valid");
            this.exportAnyButton.func_238482_a_((ITextComponent)PneumaticCraftUtils.xlate(textKey, new Object[0]));
            this.exportAnyButton.setTooltipKey(textKey + ".tooltip", new Object[0]);
        }
        this.statusStat.setText((List<ITextComponent>)ImmutableList.of((Object)PneumaticCraftUtils.xlate("pneumaticcraft.gui.pressureChamberInterface.mode", new Object[0]).func_240699_a_(TextFormatting.WHITE), (Object)PneumaticCraftUtils.xlate(((TileEntityPressureChamberInterface)this.te).interfaceMode.getTranslationKey(), new Object[0]).func_240699_a_(TextFormatting.BLACK)));
        if (this.hasEnoughPressure && !((TileEntityPressureChamberInterface)this.te).hasEnoughPressure()) {
            this.hasEnoughPressure = false;
            this.problemTab.openStat();
        } else if (((TileEntityPressureChamberInterface)this.te).hasEnoughPressure()) {
            this.hasEnoughPressure = true;
        }
    }

    @Override
    protected void addProblems(List<ITextComponent> curInfo) {
        super.addProblems(curInfo);
        if (((TileEntityPressureChamberInterface)this.te).interfaceMode == TileEntityPressureChamberInterface.InterfaceDirection.NONE) {
            curInfo.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.pressure_chamber_interface.not_formed", new Object[0]));
        } else if (!((TileEntityPressureChamberInterface)this.te).hasEnoughPressure()) {
            curInfo.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.pressure_chamber_interface.not_enough_pressure", new Object[0]));
        }
    }
}

