/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.api.crafting;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Either;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.item.IItemRegistry;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.Validate;

public class AmadronTradeResource {
    private final Either<ItemStack, FluidStack> resource;

    private AmadronTradeResource(@Nonnull ItemStack stack) {
        this.resource = Either.left((Object)stack);
    }

    private AmadronTradeResource(@Nonnull FluidStack stack) {
        this.resource = Either.right((Object)stack);
    }

    public boolean isEmpty() {
        return (Boolean)this.resource.map(ItemStack::func_190926_b, FluidStack::isEmpty);
    }

    @Deprecated
    public Type getType() {
        return (Type)((Object)this.resource.map(item -> Type.ITEM, fluidStack -> Type.FLUID));
    }

    public boolean equivalentTo(AmadronTradeResource other) {
        return (Boolean)this.resource.map(itemStack -> itemStack.func_77973_b() == other.getItem().func_77973_b(), fluidStack -> fluidStack.getFluid() == other.getFluid().getFluid());
    }

    public static AmadronTradeResource of(ItemStack stack) {
        return new AmadronTradeResource(stack);
    }

    public static AmadronTradeResource of(FluidStack stack) {
        return new AmadronTradeResource(stack);
    }

    public static AmadronTradeResource fromPacketBuf(PacketBuffer pb) {
        Type type = (Type)pb.func_179257_a(Type.class);
        switch (type) {
            case ITEM: {
                return new AmadronTradeResource(pb.func_150791_c());
            }
            case FLUID: {
                return new AmadronTradeResource(FluidStack.loadFluidStackFromNBT((CompoundNBT)pb.func_150793_b()));
            }
        }
        throw new IllegalStateException("bad trade resource type: " + (Object)((Object)type));
    }

    public ItemStack getItem() {
        return this.resource.left().orElse(ItemStack.field_190927_a);
    }

    public FluidStack getFluid() {
        return this.resource.right().orElse(FluidStack.EMPTY);
    }

    public void accept(Consumer<ItemStack> cStack, Consumer<FluidStack> cFluid) {
        this.resource.ifLeft(cStack).ifRight(cFluid);
    }

    public <T> T apply(Function<ItemStack, T> fStack, Function<FluidStack, T> fFluid) {
        return (T)this.resource.map(fStack, fFluid);
    }

    public int totalSpaceRequired(int units) {
        return (Integer)this.resource.map(itemStack -> (itemStack.func_190916_E() * units - 1) / itemStack.func_77976_d() + 1, fluidStack -> fluidStack.getAmount() * units);
    }

    public int countTradesInInventory(LazyOptional<IItemHandler> inv) {
        return this.resource.left().map(item -> AmadronTradeResource.countItemsInHandler(item, inv) / item.func_190916_E()).orElse(0);
    }

    public int findSpaceInItemOutput(LazyOptional<IItemHandler> inv, int wantedTradeCount) {
        return this.resource.left().map(item -> Math.min(wantedTradeCount, AmadronTradeResource.findSpaceInHandler(item, wantedTradeCount, inv))).orElse(0);
    }

    public int countTradesInTank(LazyOptional<IFluidHandler> lazy) {
        return this.resource.right().map(fluid -> lazy.map(fluidHandler -> {
            FluidStack searchingFluid = fluid.copy();
            searchingFluid.setAmount(Integer.MAX_VALUE);
            FluidStack extracted = fluidHandler.drain(searchingFluid, IFluidHandler.FluidAction.SIMULATE);
            return extracted.getAmount() / fluid.getAmount();
        }).orElse(0)).orElse(0);
    }

    public int findSpaceInFluidOutput(LazyOptional<IFluidHandler> lazy, int wantedTradeCount) {
        return this.resource.right().map(fluid -> lazy.map(fluidHandler -> {
            FluidStack providingFluid = fluid.copy();
            providingFluid.setAmount(providingFluid.getAmount() * wantedTradeCount);
            int amountFilled = fluidHandler.fill(providingFluid, IFluidHandler.FluidAction.SIMULATE);
            return amountFilled / fluid.getAmount();
        }).orElse(0)).orElse(0);
    }

    public AmadronTradeResource validate() {
        this.resource.ifLeft(stack -> Validate.isTrue((!stack.func_190926_b() ? 1 : 0) != 0)).ifRight(fluidStack -> Validate.isTrue((!fluidStack.isEmpty() ? 1 : 0) != 0));
        return this;
    }

    public static AmadronTradeResource fromJson(JsonObject obj) throws CommandSyntaxException {
        Type type = Type.valueOf(obj.get("type").getAsString().toUpperCase(Locale.ROOT));
        ResourceLocation rl = new ResourceLocation(obj.get("id").getAsString());
        int amount = obj.get("amount").getAsInt();
        switch (type) {
            case ITEM: {
                Item item = (Item)ForgeRegistries.ITEMS.getValue(rl);
                if (item == null || item == Items.field_190931_a) {
                    throw new JsonSyntaxException("unknown item " + rl + "!");
                }
                ItemStack itemStack = new ItemStack((IItemProvider)item, amount);
                if (obj.has("nbt")) {
                    itemStack.func_77982_d(JsonToNBT.func_180713_a((String)JSONUtils.func_151200_h((JsonObject)obj, (String)"nbt")));
                }
                return new AmadronTradeResource(itemStack);
            }
            case FLUID: {
                Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(rl);
                if (fluid == null || fluid == Fluids.field_204541_a) {
                    throw new JsonSyntaxException("unknown fluid " + rl + "!");
                }
                FluidStack fluidStack = new FluidStack(fluid, amount);
                return new AmadronTradeResource(fluidStack);
            }
        }
        throw new JsonSyntaxException("amadron offer " + rl + " : invalid type!");
    }

    public JsonObject toJson() {
        JsonObject res = new JsonObject();
        this.resource.ifLeft(item -> {
            res.addProperty("type", Type.ITEM.name());
            ResourceLocation name = item.func_77973_b().getRegistryName();
            res.addProperty("id", name == null ? "" : name.toString());
            res.addProperty("amount", (Number)item.func_190916_E());
            if (item.func_77942_o()) {
                res.addProperty("nbt", item.func_77978_p().toString());
            }
        }).ifRight(fluid -> {
            res.addProperty("type", Type.FLUID.name());
            res.addProperty("id", fluid.getFluid().getRegistryName().toString());
            res.addProperty("amount", (Number)fluid.getAmount());
        });
        return res;
    }

    public void writeToBuf(PacketBuffer pb) {
        this.resource.ifLeft(pStack -> {
            pb.func_179249_a((Enum)Type.ITEM);
            pb.func_150788_a(pStack);
        }).ifRight(fluidStack -> {
            pb.func_179249_a((Enum)Type.FLUID);
            pb.func_150786_a(fluidStack.writeToNBT(new CompoundNBT()));
        });
    }

    public String getName() {
        return (String)this.resource.map(itemStack -> itemStack.func_200301_q().getString(), fluidStack -> fluidStack.getDisplayName().getString());
    }

    public ResourceLocation getId() {
        return (ResourceLocation)this.resource.map(itemStack -> itemStack.func_77973_b().getRegistryName(), fluidStack -> fluidStack.getFluid().getRegistryName());
    }

    public int getAmount() {
        return (Integer)this.resource.map(ItemStack::func_190916_E, FluidStack::getAmount);
    }

    public CompoundNBT writeToNBT() {
        CompoundNBT tag = new CompoundNBT();
        this.resource.ifLeft(itemStack -> {
            tag.func_74778_a("type", Type.ITEM.toString());
            tag.func_218657_a("resource", (INBT)itemStack.func_77955_b(new CompoundNBT()));
        }).ifRight(fluidStack -> {
            tag.func_74778_a("type", Type.FLUID.toString());
            tag.func_218657_a("resource", (INBT)fluidStack.writeToNBT(new CompoundNBT()));
        });
        return tag;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AmadronTradeResource)) {
            return false;
        }
        AmadronTradeResource that = (AmadronTradeResource)o;
        return (Boolean)this.resource.map(itemStack -> ItemStack.func_77989_b((ItemStack)itemStack, (ItemStack)that.getItem()), fluidStack -> fluidStack.isFluidStackIdentical(that.getFluid()));
    }

    public int hashCode() {
        return (Integer)this.resource.map(xva$0 -> Objects.hash(xva$0), xva$0 -> Objects.hash(xva$0));
    }

    public String toString() {
        return (String)this.resource.map(itemStack -> itemStack.func_190916_E() + " x " + itemStack.func_200301_q().getString(), fluidStack -> fluidStack.getAmount() + "mB " + fluidStack.getDisplayName().getString());
    }

    private static int countItemsInHandler(ItemStack item, LazyOptional<IItemHandler> lazy) {
        boolean matchNBT = item.func_77942_o();
        IItemRegistry registry = PneumaticRegistry.getInstance().getItemRegistry();
        return lazy.map(handler -> IntStream.range(0, handler.getSlots()).filter(i -> registry.doesItemMatchFilter(item, handler.getStackInSlot(i), false, matchNBT, false)).map(i -> handler.getStackInSlot(i).func_190916_E()).sum()).orElse(0);
    }

    private static int findSpaceInHandler(ItemStack item, int multiplier, LazyOptional<IItemHandler> lazy) {
        int totalItems = item.func_190916_E() * multiplier;
        return lazy.map(inv -> {
            int remaining = totalItems;
            for (int i = 0; i < inv.getSlots() && remaining > 0; ++i) {
                if (!inv.getStackInSlot(i).func_190926_b() && !ItemHandlerHelper.canItemStacksStack((ItemStack)inv.getStackInSlot(i), (ItemStack)item)) continue;
                remaining -= item.func_77976_d() - inv.getStackInSlot(i).func_190916_E();
            }
            return (totalItems - remaining) / item.func_190916_E();
        }).orElse(0);
    }

    public static enum Type {
        ITEM,
        FLUID;

    }
}

