/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.variables;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import me.desht.pneumaticcraft.common.ai.DroneAIManager;
import me.desht.pneumaticcraft.common.variables.GlobalVariableManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import org.apache.commons.lang3.StringUtils;

public class TextVariableParser {
    private final String orig;
    private final DroneAIManager variableHolder;
    private final Set<String> relevantVariables = new HashSet<String>();

    public TextVariableParser(String str) {
        this(str, null);
    }

    public TextVariableParser(String str, DroneAIManager variableHolder) {
        this.orig = str;
        this.variableHolder = variableHolder;
    }

    public String parse() {
        int index;
        String ret = this.orig;
        while ((index = ret.indexOf("${")) >= 0) {
            int secondIndex = ret.indexOf("}", index);
            if (secondIndex >= 0) {
                String varValue = this.getVariableValue(ret.substring(index + 2, secondIndex));
                ret = ret.substring(0, index) + varValue + ret.substring(secondIndex + 1);
                continue;
            }
            return ret.substring(0, index) + "Parsing error: Missing '}'";
        }
        return ret;
    }

    public Set<String> getRelevantVariables() {
        return this.relevantVariables;
    }

    private String getVariableValue(String variable) {
        String[] f = StringUtils.splitByWholeSeparator((String)variable, (String)".");
        String ext = "";
        if (f.length > 1) {
            ext = f[f.length - 1];
            variable = f.length == 2 ? f[0] : String.join((CharSequence)".", Arrays.copyOf(f, f.length - 1));
        }
        this.relevantVariables.add(variable);
        if (this.variableHolder == null) {
            String v1 = variable.startsWith("#") ? variable.substring(1) : variable;
            GlobalVariableManager gvm = GlobalVariableManager.getInstance();
            return gvm.hasItem(v1) ? this.stackToStr(gvm.getItem(v1), ext.equals("id")) : this.posToStr(gvm.getPos(v1), ext);
        }
        return this.variableHolder.hasCoordinate(variable) ? this.posToStr(this.variableHolder.getCoordinate(variable), ext) : (this.variableHolder.hasStack(variable) ? this.stackToStr(this.variableHolder.getStack(variable), ext.equals("id")) : "");
    }

    private String stackToStr(ItemStack stack, boolean id) {
        return id ? stack.func_77973_b().getRegistryName().toString() : stack.func_200301_q().getString();
    }

    private String posToStr(BlockPos pos, String ext) {
        switch (ext) {
            case "x": {
                return Integer.toString(pos.func_177958_n());
            }
            case "y": {
                return Integer.toString(pos.func_177956_o());
            }
            case "z": {
                return Integer.toString(pos.func_177952_p());
            }
        }
        return pos.func_177958_n() + ", " + pos.func_177956_o() + ", " + pos.func_177952_p();
    }
}

