/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util;

import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class EnchantmentUtils {
    public static int getPlayerXP(PlayerEntity player) {
        return (int)((float)EnchantmentUtils.getExperienceForLevel(player.field_71068_ca) + player.field_71106_cc * (float)player.func_71050_bK());
    }

    public static void addPlayerXP(PlayerEntity player, int amount) {
        int experience;
        player.field_71067_cb = experience = EnchantmentUtils.getPlayerXP(player) + amount;
        player.field_71068_ca = EnchantmentUtils.getLevelForExperience(experience);
        int expForLevel = EnchantmentUtils.getExperienceForLevel(player.field_71068_ca);
        player.field_71106_cc = (float)(experience - expForLevel) / (float)player.func_71050_bK();
    }

    public static int xpBarCap(int level) {
        if (level >= 30) {
            return 112 + (level - 30) * 9;
        }
        if (level >= 15) {
            return 37 + (level - 15) * 5;
        }
        return 7 + level * 2;
    }

    private static int sum(int n, int a0, int d) {
        return n * (2 * a0 + (n - 1) * d) / 2;
    }

    public static int getExperienceForLevel(int level) {
        if (level == 0) {
            return 0;
        }
        if (level <= 15) {
            return EnchantmentUtils.sum(level, 7, 2);
        }
        if (level <= 30) {
            return 315 + EnchantmentUtils.sum(level - 15, 37, 5);
        }
        return 1395 + EnchantmentUtils.sum(level - 30, 112, 9);
    }

    public static int getXpToNextLevel(int level) {
        int levelXP = EnchantmentUtils.getLevelForExperience(level);
        int nextXP = EnchantmentUtils.getExperienceForLevel(level + 1);
        return nextXP - levelXP;
    }

    public static int getLevelForExperience(int targetXp) {
        int level = 0;
        int xpToNextLevel;
        while (targetXp >= (xpToNextLevel = EnchantmentUtils.xpBarCap(level))) {
            ++level;
            targetXp -= xpToNextLevel;
        }
        return level;
    }

    public static float getPower(World world, BlockPos position) {
        float power = 0.0f;
        for (int deltaZ = -1; deltaZ <= 1; ++deltaZ) {
            for (int deltaX = -1; deltaX <= 1; ++deltaX) {
                if (deltaZ == 0 && deltaX == 0 || !world.func_175623_d(position.func_177982_a(deltaX, 0, deltaZ)) || !world.func_175623_d(position.func_177982_a(deltaX, 1, deltaZ))) continue;
                power += EnchantmentUtils.getEnchantPower(world, position.func_177982_a(deltaX * 2, 0, deltaZ * 2));
                power += EnchantmentUtils.getEnchantPower(world, position.func_177982_a(deltaX * 2, 1, deltaZ * 2));
                if (deltaX == 0 || deltaZ == 0) continue;
                power += EnchantmentUtils.getEnchantPower(world, position.func_177982_a(deltaX * 2, 0, deltaZ));
                power += EnchantmentUtils.getEnchantPower(world, position.func_177982_a(deltaX * 2, 1, deltaZ));
                power += EnchantmentUtils.getEnchantPower(world, position.func_177982_a(deltaX, 0, deltaZ * 2));
                power += EnchantmentUtils.getEnchantPower(world, position.func_177982_a(deltaX, 1, deltaZ * 2));
            }
        }
        return power;
    }

    public static float getEnchantPower(World world, BlockPos pos) {
        return world.func_180495_p(pos).getEnchantPowerBonus((IWorldReader)world, pos);
    }

    public static void addAllBooks(Enchantment enchantment, List<ItemStack> items) {
        for (int i = enchantment.func_77319_d(); i <= enchantment.func_77325_b(); ++i) {
            items.add(EnchantedBookItem.func_92111_a((EnchantmentData)new EnchantmentData(enchantment, i)));
        }
    }
}

