/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util;

import net.minecraft.util.Direction;

public class DirectionUtil {
    public static final Direction[] VALUES = new Direction[]{Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};
    public static final Direction[] HORIZONTALS = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};

    public static Direction rotateAround(Direction dir, Direction.Axis axis) {
        switch (axis) {
            case X: {
                return dir.func_176740_k() == Direction.Axis.X ? dir : DirectionUtil.rotateX(dir);
            }
            case Y: {
                return dir.func_176740_k() == Direction.Axis.Y ? dir : dir.func_176746_e();
            }
            case Z: {
                return dir.func_176740_k() == Direction.Axis.Z ? dir : DirectionUtil.rotateZ(dir);
            }
        }
        throw new IllegalStateException("Unable to get CW facing for axis " + axis);
    }

    private static Direction rotateX(Direction dir) {
        switch (dir) {
            case NORTH: {
                return Direction.DOWN;
            }
            case SOUTH: {
                return Direction.UP;
            }
            case UP: {
                return Direction.NORTH;
            }
            case DOWN: {
                return Direction.SOUTH;
            }
        }
        throw new IllegalStateException("Unable to get X-rotated facing of " + dir);
    }

    private static Direction rotateZ(Direction dir) {
        switch (dir) {
            case EAST: {
                return Direction.DOWN;
            }
            case WEST: {
                return Direction.UP;
            }
            case UP: {
                return Direction.EAST;
            }
            case DOWN: {
                return Direction.WEST;
            }
        }
        throw new IllegalStateException("Unable to get Z-rotated facing of " + dir);
    }
}

