/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.client.util.TintColor;
import me.desht.pneumaticcraft.common.core.ModTileEntities;
import me.desht.pneumaticcraft.common.heat.HeatExchangerLogicAmbient;
import me.desht.pneumaticcraft.common.heat.HeatUtil;
import me.desht.pneumaticcraft.common.heat.SyncedTemperature;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.tileentity.IHeatExchangingTE;
import me.desht.pneumaticcraft.common.tileentity.IHeatTinted;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPneumaticBase;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class TileEntityVortexTube
extends TileEntityPneumaticBase
implements IHeatTinted,
IHeatExchangingTE {
    private final IHeatExchangerLogic hotHeatExchanger = PneumaticRegistry.getInstance().getHeatRegistry().makeHeatExchangerLogic();
    private final LazyOptional<IHeatExchangerLogic> hotHeatCap = LazyOptional.of(() -> this.hotHeatExchanger);
    private final IHeatExchangerLogic coldHeatExchanger = PneumaticRegistry.getInstance().getHeatRegistry().makeHeatExchangerLogic();
    private final LazyOptional<IHeatExchangerLogic> coldHeatCap = LazyOptional.of(() -> this.coldHeatExchanger);
    private final IHeatExchangerLogic connectingExchanger = PneumaticRegistry.getInstance().getHeatRegistry().makeHeatExchangerLogic();
    @DescSynced
    private final SyncedTemperature syncHot = new SyncedTemperature(this.hotHeatExchanger);
    @DescSynced
    private final SyncedTemperature syncCold = new SyncedTemperature(this.coldHeatExchanger);

    public TileEntityVortexTube() {
        super((TileEntityType)ModTileEntities.VORTEX_TUBE.get(), 20.0f, 25.0f, 2000, 0);
        this.coldHeatExchanger.setThermalResistance(0.01);
        this.hotHeatExchanger.setThermalResistance(0.01);
        this.connectingExchanger.setThermalResistance(100.0);
        this.connectingExchanger.addConnectedExchanger(this.coldHeatExchanger);
        this.connectingExchanger.addConnectedExchanger(this.hotHeatExchanger);
    }

    @Override
    public LazyOptional<IHeatExchangerLogic> getHeatCap(Direction side) {
        if (side == null || side == this.getRotation().func_176734_d()) {
            return this.hotHeatCap;
        }
        if (side == this.getRotation()) {
            return this.coldHeatCap;
        }
        return LazyOptional.empty();
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return null;
    }

    @Override
    public boolean canConnectPneumatic(Direction side) {
        return side != this.getRotation() && side != this.getRotation().func_176734_d();
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        tag.func_218657_a("coldHeat", (INBT)this.coldHeatExchanger.serializeNBT());
        tag.func_218657_a("connector", (INBT)this.connectingExchanger.serializeNBT());
        return tag;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.coldHeatExchanger.deserializeNBT(tag.func_74775_l("coldHeat"));
        this.connectingExchanger.deserializeNBT(tag.func_74775_l("connector"));
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.func_145831_w().field_72995_K) {
            this.connectingExchanger.tick();
            this.coldHeatExchanger.tick();
            int usedAir = (int)(this.getPressure() * 10.0f);
            if (usedAir > 0) {
                this.addAir(-usedAir);
                double generatedHeat = (double)usedAir / 10.0;
                this.coldHeatExchanger.addHeat(-generatedHeat);
                this.hotHeatExchanger.addHeat(generatedHeat);
            }
            this.syncHot.tick();
            this.syncCold.tick();
        }
    }

    @Override
    protected boolean shouldRerenderChunkOnDescUpdate() {
        return true;
    }

    @Override
    public TintColor getColorForTintIndex(int tintIndex) {
        switch (tintIndex) {
            case 1: {
                return HeatUtil.getColourForTemperature(this.syncHot.getSyncedTemp());
            }
            case 2: {
                return HeatUtil.getColourForTemperature(this.syncCold.getSyncedTemp());
            }
        }
        return HeatUtil.getColourForTemperature(300);
    }

    @Override
    public IHeatExchangerLogic getHeatExchanger(Direction dir) {
        if (dir == null || dir == this.getRotation().func_176734_d()) {
            return this.hotHeatExchanger;
        }
        if (dir == this.getRotation()) {
            return this.coldHeatExchanger;
        }
        return null;
    }

    @Override
    public void initHeatExchangersOnPlacement(World world, BlockPos pos) {
        double temp = HeatExchangerLogicAmbient.getAmbientTemperature((IWorld)world, pos);
        this.hotHeatExchanger.setTemperature(temp);
        this.coldHeatExchanger.setTemperature(temp);
    }
}

