/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import me.desht.pneumaticcraft.api.tileentity.IManoMeasurable;
import me.desht.pneumaticcraft.common.block.BlockPressureChamberWall;
import me.desht.pneumaticcraft.common.block.BlockPressureChamberWallBase;
import me.desht.pneumaticcraft.common.core.ModTileEntities;
import me.desht.pneumaticcraft.common.thirdparty.waila.IInfoForwarder;
import me.desht.pneumaticcraft.common.tileentity.TileEntityBase;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPressureChamberValve;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Pair;

public class TileEntityPressureChamberWall
extends TileEntityBase
implements IManoMeasurable,
IInfoForwarder {
    private TileEntityPressureChamberValve teValve;
    private BlockPos valvePos;

    public TileEntityPressureChamberWall() {
        this((TileEntityType)ModTileEntities.PRESSURE_CHAMBER_WALL.get(), 0);
    }

    TileEntityPressureChamberWall(TileEntityType type, int upgradeSize) {
        super(type, upgradeSize);
    }

    public TileEntityPressureChamberValve getPrimaryValve() {
        if (this.teValve == null && this.valvePos != null) {
            TileEntity te = this.func_145831_w().func_175625_s(this.valvePos);
            this.setPrimaryValve(te instanceof TileEntityPressureChamberValve ? (TileEntityPressureChamberValve)te : null);
        }
        return this.teValve;
    }

    void setPrimaryValve(TileEntityPressureChamberValve newValve) {
        boolean valveChanging = this.teValve != newValve || newValve == null && this.valvePos != null || newValve != null && this.valvePos == null;
        BlockPos blockPos = this.valvePos = newValve == null ? null : newValve.func_174877_v();
        if (valveChanging && !this.func_145831_w().field_72995_K) {
            this.teValve = newValve;
            PressureWallStateManager.addDeferredUpdate(this, this.teValve);
            this.func_70296_d();
        }
    }

    public void onBlockBreak() {
        this.teValve = this.getPrimaryValve();
        if (this.teValve != null) {
            this.teValve.onMultiBlockBreak();
        }
    }

    private void updateBlockState(TileEntityPressureChamberValve valve) {
        if (!(this.func_145837_r() || valve != null && valve.func_145837_r() || !this.func_195044_w().func_235901_b_(BlockPressureChamberWallBase.WALL_STATE))) {
            this.func_145831_w().func_180501_a(this.func_174877_v(), this.calcNewBlockState(valve), 2);
        }
    }

    private BlockState calcNewBlockState(TileEntityPressureChamberValve valve) {
        BlockPressureChamberWall.WallState wallState = BlockPressureChamberWall.WallState.NONE;
        if (valve != null && !valve.func_145837_r()) {
            boolean zMax;
            boolean xMin = this.func_174877_v().func_177958_n() == valve.multiBlockX;
            boolean yMin = this.func_174877_v().func_177956_o() == valve.multiBlockY;
            boolean zMin = this.func_174877_v().func_177952_p() == valve.multiBlockZ;
            boolean xMax = this.func_174877_v().func_177958_n() == valve.multiBlockX + valve.multiBlockSize - 1;
            boolean yMax = this.func_174877_v().func_177956_o() == valve.multiBlockY + valve.multiBlockSize - 1;
            boolean bl = zMax = this.func_174877_v().func_177952_p() == valve.multiBlockZ + valve.multiBlockSize - 1;
            wallState = xMin && yMin && zMin || xMax && yMax && zMax ? BlockPressureChamberWall.WallState.XMIN_YMIN_ZMIN : (xMin && yMin && zMax || xMax && yMax && zMin ? BlockPressureChamberWall.WallState.XMIN_YMIN_ZMAX : (xMin && yMax && zMax || xMax && yMin && zMin ? BlockPressureChamberWall.WallState.XMIN_YMAX_ZMAX : (xMin && yMax && zMin || xMax && yMin && zMax ? BlockPressureChamberWall.WallState.XMIN_YMAX_ZMIN : (yMin && xMin || yMax && xMax || yMin && xMax || yMax && xMin ? BlockPressureChamberWall.WallState.XEDGE : (yMin && zMin || yMax && zMax || yMin && zMax || yMax && zMin ? BlockPressureChamberWall.WallState.ZEDGE : (!yMin && !yMax ? (xMin && zMin || xMax && zMax || xMin && zMax || xMax && zMin ? BlockPressureChamberWall.WallState.YEDGE : BlockPressureChamberWall.WallState.CENTER) : BlockPressureChamberWall.WallState.CENTER))))));
        }
        return (BlockState)this.func_195044_w().func_206870_a(BlockPressureChamberWallBase.WALL_STATE, (Comparable)((Object)wallState));
    }

    @Override
    public void onDescUpdate() {
        super.onDescUpdate();
        this.teValve = null;
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return null;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.valvePos = tag.func_74767_n("noValve") ? null : (tag.func_74764_b("valvePos") ? NBTUtil.func_186861_c((CompoundNBT)tag.func_74775_l("valvePos")) : new BlockPos(tag.func_74762_e("valveX"), tag.func_74762_e("valveY"), tag.func_74762_e("valveZ")));
        this.teValve = null;
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        if (this.valvePos == null) {
            tag.func_74757_a("noValve", true);
        } else {
            tag.func_218657_a("valvePos", (INBT)NBTUtil.func_186859_a((BlockPos)this.valvePos));
        }
        return tag;
    }

    @Override
    public void printManometerMessage(PlayerEntity player, List<ITextComponent> curInfo) {
        if (this.getPrimaryValve() != null) {
            this.teValve.airHandler.printManometerMessage(player, curInfo);
        }
    }

    @Override
    protected boolean shouldRerenderChunkOnDescUpdate() {
        return true;
    }

    @Override
    public TileEntity getInfoTileEntity() {
        return this.getPrimaryValve();
    }

    @Mod.EventBusSubscriber(modid="pneumaticcraft")
    public static class PressureWallStateManager {
        private static final Deque<Pair<TileEntityPressureChamberWall, TileEntityPressureChamberValve>> todo = new ArrayDeque<Pair<TileEntityPressureChamberWall, TileEntityPressureChamberValve>>();

        @SubscribeEvent
        public static void onServerTick(TickEvent.ServerTickEvent event) {
            if (event.phase == TickEvent.Phase.END) {
                while (!todo.isEmpty()) {
                    Pair<TileEntityPressureChamberWall, TileEntityPressureChamberValve> pair = todo.poll();
                    ((TileEntityPressureChamberWall)pair.getLeft()).updateBlockState((TileEntityPressureChamberValve)pair.getRight());
                }
            }
        }

        private static void addDeferredUpdate(TileEntityPressureChamberWall wall, TileEntityPressureChamberValve valve) {
            todo.offer((Pair<TileEntityPressureChamberWall, TileEntityPressureChamberValve>)Pair.of((Object)wall, (Object)valve));
        }
    }
}

