/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.common.core.ModTileEntities;
import me.desht.pneumaticcraft.common.heat.HeatExchangerLogicAmbient;
import me.desht.pneumaticcraft.common.tileentity.TileEntityCompressedIronBlock;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.IWorld;
import net.minecraftforge.common.util.LazyOptional;

public class TileEntityHeatSink
extends TileEntityCompressedIronBlock {
    private final IHeatExchangerLogic airExchanger = PneumaticRegistry.getInstance().getHeatRegistry().makeHeatExchangerLogic();
    private double ambientTemp;

    public TileEntityHeatSink() {
        super((TileEntityType)ModTileEntities.HEAT_SINK.get());
        this.heatExchanger.setThermalCapacity(5.0);
        this.airExchanger.addConnectedExchanger(this.heatExchanger);
        this.airExchanger.setThermalResistance(14.0);
    }

    @Override
    protected boolean shouldRerenderChunkOnDescUpdate() {
        return true;
    }

    @Override
    protected void onFirstServerTick() {
        super.onFirstServerTick();
        this.ambientTemp = HeatExchangerLogicAmbient.getAmbientTemperature((IWorld)this.func_145831_w(), this.func_174877_v());
        this.airExchanger.setTemperature(this.ambientTemp);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_218657_a("airExchanger", (INBT)this.airExchanger.serializeNBT());
        return super.func_189515_b(tag);
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.airExchanger.deserializeNBT(tag.func_74775_l("airExchanger"));
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            this.airExchanger.tick();
            this.airExchanger.setTemperature(this.ambientTemp);
        }
    }

    public void onFannedByAirGrate() {
        this.heatExchanger.tick();
        this.airExchanger.setTemperature(this.ambientTemp);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (double)(this.func_174877_v().func_177958_n() + 1), (double)(this.func_174877_v().func_177956_o() + 1), (double)(this.func_174877_v().func_177952_p() + 1));
    }

    @Override
    public LazyOptional<IHeatExchangerLogic> getHeatCap(Direction side) {
        return side == null || side == this.getRotation() ? super.getHeatCap(side) : LazyOptional.empty();
    }
}

