/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.common.core.ModTileEntities;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.tileentity.IComparatorSupport;
import me.desht.pneumaticcraft.common.tileentity.TileEntityBase;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class TileEntityDisplayTable
extends TileEntityBase
implements IComparatorSupport {
    private final DisplayItemHandler inventory = new DisplayItemHandler(this, 1);
    private final LazyOptional<IItemHandler> invCap = LazyOptional.of(() -> this.inventory);
    public ItemStack displayedStack = ItemStack.field_190927_a;

    public TileEntityDisplayTable() {
        super((TileEntityType)ModTileEntities.DISPLAY_TABLE.get());
    }

    TileEntityDisplayTable(TileEntityType<?> type) {
        super(type);
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return this.inventory;
    }

    @Override
    @Nonnull
    protected LazyOptional<IItemHandler> getInventoryCap() {
        return this.invCap;
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_218657_a("Items", (INBT)this.inventory.serializeNBT());
        return super.func_189515_b(tag);
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.inventory.deserializeNBT(tag.func_74775_l("Items"));
        this.displayedStack = this.inventory.getStackInSlot(0);
    }

    @Override
    public void writeToPacket(CompoundNBT tag) {
        super.writeToPacket(tag);
        tag.func_218657_a("Item", (INBT)this.displayedStack.func_77955_b(new CompoundNBT()));
    }

    @Override
    public void readFromPacket(CompoundNBT tag) {
        super.readFromPacket(tag);
        this.displayedStack = ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l("Item"));
    }

    @Override
    public int getComparatorValue() {
        return this.inventory.getStackInSlot(0).func_190926_b() ? 0 : 15;
    }

    class DisplayItemHandler
    extends BaseItemStackHandler {
        DisplayItemHandler(TileEntityDisplayTable te, int size) {
            super(te, size);
        }

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (slot == 0) {
                TileEntityDisplayTable.this.displayedStack = this.getStackInSlot(0);
                if (!((TileEntityDisplayTable)TileEntityDisplayTable.this).field_145850_b.field_72995_K) {
                    TileEntityDisplayTable.this.sendDescriptionPacket();
                }
            }
        }

        public int getSlotLimit(int slot) {
            return 1;
        }
    }
}

