/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.api.tileentity.IAirHandler;
import me.desht.pneumaticcraft.common.block.BlockChargingStation;
import me.desht.pneumaticcraft.common.core.ModTileEntities;
import me.desht.pneumaticcraft.common.inventory.ContainerChargingStation;
import me.desht.pneumaticcraft.common.inventory.ContainerChargingStationUpgradeManager;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.inventory.handler.ChargeableItemHandler;
import me.desht.pneumaticcraft.common.item.IChargeableContainerProvider;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.tileentity.ICamouflageableTE;
import me.desht.pneumaticcraft.common.tileentity.IRedstoneControl;
import me.desht.pneumaticcraft.common.tileentity.RedstoneController;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPneumaticBase;
import me.desht.pneumaticcraft.common.util.GlobalTileEntityCacheManager;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.IItemHandler;

public class TileEntityChargingStation
extends TileEntityPneumaticBase
implements IRedstoneControl<TileEntityChargingStation>,
ICamouflageableTE,
INamedContainerProvider {
    private static final List<RedstoneController.RedstoneMode<TileEntityChargingStation>> REDSTONE_MODES = ImmutableList.of(new RedstoneController.EmittingRedstoneMode<TileEntityChargingStation>("standard.never", new ItemStack((IItemProvider)Items.field_151016_H), te -> false), new RedstoneController.EmittingRedstoneMode<TileEntityChargingStation>("chargingStation.idle", Textures.GUI_CHARGE_IDLE, TileEntityChargingStation::isIdle), new RedstoneController.EmittingRedstoneMode<TileEntityChargingStation>("chargingStation.charging", Textures.GUI_CHARGING, te -> te.charging), new RedstoneController.EmittingRedstoneMode<TileEntityChargingStation>("chargingStation.discharging", Textures.GUI_DISCHARGING, te -> te.discharging));
    private static final int INVENTORY_SIZE = 1;
    public static final int CHARGE_INVENTORY_INDEX = 0;
    private static final int MAX_REDSTONE_UPDATE_FREQ = 10;
    @DescSynced
    private ItemStack chargingStackSynced = ItemStack.field_190927_a;
    private ChargingStationHandler itemHandler = new ChargingStationHandler();
    private final LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.itemHandler);
    private ChargeableItemHandler chargeableInventory;
    @GuiSynced
    public float chargingItemPressure;
    @GuiSynced
    public boolean charging;
    @GuiSynced
    public boolean discharging;
    private boolean oldRedstoneStatus;
    private BlockState camoState;
    private long lastRedstoneUpdate;
    private int pendingRedstoneStatus = -1;
    @GuiSynced
    private final RedstoneController<TileEntityChargingStation> rsController = new RedstoneController<TileEntityChargingStation>(this, REDSTONE_MODES);
    @GuiSynced
    public boolean upgradeOnly = false;

    public TileEntityChargingStation() {
        super((TileEntityType)ModTileEntities.CHARGING_STATION.get(), 20.0f, 25.0f, 1000, 4);
    }

    @Nonnull
    public ItemStack getChargingStack() {
        return this.itemHandler.getStackInSlot(0);
    }

    @Nonnull
    public ItemStack getChargingStackSynced() {
        return this.chargingStackSynced;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            this.discharging = false;
            this.charging = false;
            this.chargingStackSynced = this.itemHandler.getStackInSlot(0);
            int airToTransfer = (int)(10.0f * this.getSpeedMultiplierFromUpgrades());
            for (IAirHandler itemAirHandler : this.findChargeable()) {
                float itemPressure = itemAirHandler.getPressure();
                float itemVolume = itemAirHandler.getVolume();
                float chargerPressure = this.getPressure();
                float delta = Math.abs(chargerPressure - itemPressure) / 2.0f;
                int airInItem = itemAirHandler.getAir();
                if (PneumaticCraftUtils.epsilonEquals(chargerPressure, 0.0f) && delta < 0.1f) {
                    itemAirHandler.addAir(-airInItem);
                    continue;
                }
                if (itemPressure > chargerPressure + 0.01f && itemPressure > 0.0f) {
                    int airToMove = Math.min(Math.min(airToTransfer, airInItem), (int)(delta * (float)this.airHandler.getVolume()));
                    itemAirHandler.addAir(-airToMove);
                    this.addAir(airToMove);
                    this.discharging = true;
                    continue;
                }
                if (!(itemPressure < chargerPressure - 0.01f) || !(itemPressure < itemAirHandler.maxPressure())) continue;
                int maxAirInItem = (int)(itemAirHandler.maxPressure() * itemVolume);
                float boost = chargerPressure < 15.0f ? 1.0f : 1.0f + (chargerPressure - 15.0f) / 5.0f;
                int airToMove = Math.min(Math.min((int)((float)airToTransfer * boost), this.airHandler.getAir()), maxAirInItem - airInItem);
                airToMove = Math.min((int)(delta * itemVolume), airToMove);
                itemAirHandler.addAir(airToMove);
                this.addAir(-airToMove);
                this.charging = true;
            }
            boolean shouldEmit = this.rsController.shouldEmit();
            if (this.oldRedstoneStatus != shouldEmit) {
                if (this.field_145850_b.func_82737_E() - this.lastRedstoneUpdate > 10L) {
                    this.updateRedstoneOutput();
                } else {
                    this.pendingRedstoneStatus = shouldEmit ? 1 : 0;
                }
            } else if (this.pendingRedstoneStatus != -1 && this.field_145850_b.func_82737_E() - this.lastRedstoneUpdate > 10L) {
                this.updateRedstoneOutput();
            }
            this.airHandler.setSideLeaking(!this.upgradeOnly && this.hasNoConnectedAirHandlers() ? this.getRotation() : null);
        }
    }

    private void updateRedstoneOutput() {
        this.oldRedstoneStatus = this.rsController.shouldEmit();
        this.updateNeighbours();
        this.pendingRedstoneStatus = -1;
        this.lastRedstoneUpdate = this.field_145850_b.func_82737_E();
    }

    private List<IAirHandler> findChargeable() {
        if (this.upgradeOnly) {
            return Collections.emptyList();
        }
        ArrayList<IAirHandler> res = new ArrayList<IAirHandler>();
        if (this.getChargingStack().func_190916_E() == 1) {
            this.getChargingStack().getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY).ifPresent(h -> {
                res.add((IAirHandler)h);
                this.chargingItemPressure = h.getPressure();
            });
        }
        if (this.getUpgrades(EnumUpgrade.DISPENSER) > 0) {
            List entitiesOnPad = this.func_145831_w().func_217357_a(Entity.class, new AxisAlignedBB(this.func_174877_v().func_177984_a()));
            for (Entity entity : entitiesOnPad) {
                if (entity instanceof ItemEntity) {
                    ((ItemEntity)entity).func_92059_d().getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY).ifPresent(res::add);
                    continue;
                }
                if (entity instanceof PlayerEntity) {
                    PlayerInventory inv = ((PlayerEntity)entity).field_71071_by;
                    for (int i = 0; i < inv.func_70302_i_(); ++i) {
                        ItemStack stack = inv.func_70301_a(i);
                        if (stack.func_190916_E() != 1) continue;
                        stack.getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY).ifPresent(res::add);
                    }
                    continue;
                }
                entity.getCapability(PNCCapabilities.AIR_HANDLER_CAPABILITY).ifPresent(res::add);
            }
        }
        return res;
    }

    @Override
    public boolean canConnectPneumatic(Direction side) {
        return this.getRotation() == side;
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayerEntity player) {
        if (this.rsController.parseRedstoneMode(tag)) {
            return;
        }
        switch (tag) {
            case "open_upgrades": {
                if (!(this.getChargingStack().func_77973_b() instanceof IChargeableContainerProvider)) break;
                INamedContainerProvider provider = ((IChargeableContainerProvider)this.getChargingStack().func_77973_b()).getContainerProvider(this);
                NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)provider, (BlockPos)this.func_174877_v());
                break;
            }
            case "close_upgrades": {
                NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)this, (BlockPos)this.func_174877_v());
                break;
            }
            case "toggle_upgrade_only": {
                this.upgradeOnly = !this.upgradeOnly;
            }
        }
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return this.itemHandler;
    }

    private boolean isIdle() {
        return !this.charging && !this.discharging && !this.getChargingStack().func_190926_b() && this.getChargingStack().getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY).isPresent();
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (double)(this.func_174877_v().func_177958_n() + 1), (double)(this.func_174877_v().func_177956_o() + 1), (double)(this.func_174877_v().func_177952_p() + 1));
    }

    public ChargeableItemHandler getChargeableInventory() {
        return this.func_145831_w().field_72995_K ? new ChargeableItemHandler(this) : this.chargeableInventory;
    }

    @Override
    protected LazyOptional<IItemHandler> getInventoryCap() {
        return this.inventoryCap;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.itemHandler = new ChargingStationHandler();
        this.itemHandler.deserializeNBT(tag.func_74775_l("Items"));
        ItemStack chargeSlot = this.getChargingStack();
        if (chargeSlot.func_77973_b() instanceof IChargeableContainerProvider) {
            this.chargeableInventory = new ChargeableItemHandler(this);
        }
        this.upgradeOnly = tag.func_74767_n("UpgradeOnly");
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        if (this.chargeableInventory != null) {
            this.chargeableInventory.writeToNBT();
        }
        tag.func_218657_a("Items", (INBT)this.itemHandler.serializeNBT());
        if (this.upgradeOnly) {
            tag.func_74757_a("UpgradeOnly", true);
        }
        return tag;
    }

    @Override
    public void serializeExtraItemData(CompoundNBT blockEntityTag, boolean preserveState) {
        if (this.upgradeOnly) {
            blockEntityTag.func_74757_a("UpgradeOnly", true);
        }
    }

    @Override
    public void writeToPacket(CompoundNBT tag) {
        super.writeToPacket(tag);
        ICamouflageableTE.writeCamo(tag, this.camoState);
    }

    @Override
    public void readFromPacket(CompoundNBT tag) {
        super.readFromPacket(tag);
        this.camoState = ICamouflageableTE.readCamo(tag);
    }

    @Override
    public void onUpgradesChanged() {
        super.onUpgradesChanged();
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)state.func_206870_a((Property)BlockChargingStation.CHARGE_PAD, (Comparable)Boolean.valueOf(this.getUpgrades(EnumUpgrade.DISPENSER) > 0)));
        }
    }

    @Override
    public RedstoneController<TileEntityChargingStation> getRedstoneController() {
        return this.rsController;
    }

    @Override
    protected boolean shouldRerenderChunkOnDescUpdate() {
        return true;
    }

    @Override
    public BlockState getCamouflage() {
        return this.camoState;
    }

    @Override
    public void setCamouflage(BlockState state) {
        this.camoState = state;
        ICamouflageableTE.syncToClient(this);
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        GlobalTileEntityCacheManager.getInstance().chargingStations.remove(this);
    }

    public void func_145829_t() {
        super.func_145829_t();
        GlobalTileEntityCacheManager.getInstance().chargingStations.add(this);
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerChargingStation(i, playerInventory, this.func_174877_v());
    }

    private class ChargingStationHandler
    extends BaseItemStackHandler {
        ChargingStationHandler() {
            super(TileEntityChargingStation.this, 1);
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        public boolean isItemValid(int slot, ItemStack itemStack) {
            return slot == 0 && (itemStack.func_190926_b() || itemStack.getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY).isPresent());
        }

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            TileEntityChargingStation teCS = TileEntityChargingStation.this;
            ItemStack newStack = this.getStackInSlot(slot);
            if (!ItemStack.func_179545_c((ItemStack)TileEntityChargingStation.this.chargingStackSynced, (ItemStack)newStack)) {
                TileEntityChargingStation.this.chargingStackSynced = new ItemStack((IItemProvider)newStack.func_77973_b());
            }
            if (teCS.func_145831_w().field_72995_K || slot != 0) {
                return;
            }
            teCS.chargeableInventory = newStack.func_77973_b() instanceof IChargeableContainerProvider ? new ChargeableItemHandler(teCS) : null;
            for (PlayerEntity player : teCS.func_145831_w().func_217369_A()) {
                if (!(player instanceof ServerPlayerEntity) || !(player.field_71070_bA instanceof ContainerChargingStationUpgradeManager) || ((ContainerChargingStationUpgradeManager)player.field_71070_bA).te != this.te) continue;
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)TileEntityChargingStation.this, (BlockPos)TileEntityChargingStation.this.func_174877_v());
            }
        }
    }
}

