/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Either;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.tileentity.IRedstoneControl;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.lang3.Validate;

public class RedstoneController<T extends TileEntity> {
    private static final Pattern RS_TAG_PATTERN = Pattern.compile("^redstone:(\\d+)$");
    private final WeakReference<T> teRef;
    private final List<RedstoneMode<T>> modes;
    @GuiSynced
    private int currentMode;
    @GuiSynced
    private int currentRedstonePower = -1;

    public RedstoneController(T te) {
        this.teRef = new WeakReference<T>(te);
        this.modes = new StandardReceivingModes().modes();
    }

    public RedstoneController(T te, List<RedstoneMode<T>> modes) {
        Validate.isTrue((modes.size() >= 2 ? 1 : 0) != 0, (String)"must have at least 2 modes!", (Object[])new Object[0]);
        this.teRef = new WeakReference<T>(te);
        this.modes = modes;
    }

    public int getModeCount() {
        return this.modes.size();
    }

    public RedstoneMode<T> getModeDetails(int idx) {
        return this.modes.get(idx);
    }

    public int getCurrentMode() {
        return this.currentMode;
    }

    public void setCurrentMode(int currentMode) {
        if (currentMode != this.currentMode && currentMode >= 0 && currentMode < this.modes.size()) {
            this.currentMode = currentMode;
            TileEntity te = (TileEntity)this.teRef.get();
            if (te != null) {
                ((IRedstoneControl)te).onRedstoneModeChanged(this.currentMode);
                te.func_70296_d();
            }
        }
    }

    public int getCurrentRedstonePower() {
        if (this.currentRedstonePower < 0) {
            this.updateRedstonePower();
        }
        return this.currentRedstonePower;
    }

    public boolean shouldRun() {
        TileEntity te = (TileEntity)this.teRef.get();
        return te != null && ((RedstoneMode)this.modes.get(this.currentMode)).runPredicate.test(te);
    }

    public boolean shouldEmit() {
        TileEntity te = (TileEntity)this.teRef.get();
        return te != null && ((RedstoneMode)this.modes.get(this.currentMode)).emissionPredicate.test(te);
    }

    public void serialize(CompoundNBT tag) {
        if (this.currentMode != 0) {
            tag.func_74768_a("redstoneMode", this.currentMode);
        }
    }

    public void deserialize(CompoundNBT tag) {
        this.currentMode = tag.func_150297_b("redstoneMode", 1) ? (int)tag.func_74771_c("redstoneMode") : tag.func_74762_e("redstoneMode");
    }

    public boolean parseRedstoneMode(String tag) {
        Matcher m = RS_TAG_PATTERN.matcher(tag);
        if (m.matches() && m.groupCount() == 1) {
            this.setCurrentMode(Integer.parseInt(m.group(1)));
            return true;
        }
        return false;
    }

    public void updateRedstonePower() {
        TileEntity te = (TileEntity)this.teRef.get();
        if (te != null) {
            this.currentRedstonePower = te.func_145831_w().func_175687_A(te.func_174877_v());
        }
    }

    public boolean isEmitter() {
        return !this.modes.isEmpty() && this.modes.get(0) instanceof EmittingRedstoneMode;
    }

    public ITextComponent getRedstoneTabTitle() {
        TileEntity te = (TileEntity)this.teRef.get();
        return te != null ? ((IRedstoneControl)te).getRedstoneTabTitle() : StringTextComponent.field_240750_d_;
    }

    public ITextComponent getDescription() {
        TileEntity te = (TileEntity)this.teRef.get();
        if (te != null) {
            return ((IRedstoneControl)te).getRedstoneTabTitle().func_240702_b_(": ").func_230529_a_((ITextComponent)PneumaticCraftUtils.xlate(this.modes.get(this.currentMode).getTranslationKey(), new Object[0]).func_240699_a_(TextFormatting.YELLOW));
        }
        return StringTextComponent.field_240750_d_;
    }

    private static class StandardReceivingModes<T extends TileEntity> {
        private StandardReceivingModes() {
        }

        public List<RedstoneMode<T>> modes() {
            return ImmutableList.of(new ReceivingRedstoneMode<TileEntity>("standard.always", new ItemStack((IItemProvider)Items.field_151016_H), te -> true), new ReceivingRedstoneMode<TileEntity>("standard.high_signal", new ItemStack((IItemProvider)Items.field_151137_ax), te -> ((IRedstoneControl)te).getCurrentRedstonePower() > 0), new ReceivingRedstoneMode<TileEntity>("standard.low_signal", new ItemStack((IItemProvider)Items.field_221764_cr), te -> ((IRedstoneControl)te).getCurrentRedstonePower() == 0));
        }
    }

    public static class ReceivingRedstoneMode<T extends TileEntity>
    extends RedstoneMode<T> {
        public ReceivingRedstoneMode(String id, ResourceLocation texture, Predicate<T> runPredicate) {
            super(id, texture, runPredicate, (T t) -> false);
        }

        public ReceivingRedstoneMode(String id, ItemStack stackIcon, Predicate<T> runPredicate) {
            super(id, stackIcon, runPredicate, (T te) -> false);
        }
    }

    public static class EmittingRedstoneMode<T extends TileEntity>
    extends RedstoneMode<T> {
        public EmittingRedstoneMode(String id, ResourceLocation texture, Predicate<T> emissionPredicate) {
            super(id, texture, (T te) -> false, emissionPredicate);
        }

        public EmittingRedstoneMode(String id, ItemStack stackIcon, Predicate<T> emissionPredicate) {
            super(id, stackIcon, (T te) -> false, emissionPredicate);
        }
    }

    public static abstract class RedstoneMode<T extends TileEntity> {
        private final String id;
        private final Either<ItemStack, ResourceLocation> texture;
        private final Predicate<T> runPredicate;
        private final Predicate<T> emissionPredicate;

        public RedstoneMode(String id, ItemStack stackIcon, Predicate<T> runPredicate, Predicate<T> emissionPredicate) {
            this(id, (Either<ItemStack, ResourceLocation>)Either.left((Object)stackIcon), runPredicate, emissionPredicate);
        }

        public RedstoneMode(String id, ResourceLocation texture, Predicate<T> runPredicate, Predicate<T> emissionPredicate) {
            this(id, (Either<ItemStack, ResourceLocation>)Either.right((Object)texture), runPredicate, emissionPredicate);
        }

        private RedstoneMode(String id, Either<ItemStack, ResourceLocation> texture, Predicate<T> runPredicate, Predicate<T> emissionPredicate) {
            this.id = id;
            this.runPredicate = runPredicate;
            this.emissionPredicate = emissionPredicate;
            this.texture = texture;
        }

        public String getId() {
            return this.id;
        }

        public Either<ItemStack, ResourceLocation> getTexture() {
            return this.texture;
        }

        public String getTranslationKey() {
            return "pneumaticcraft.gui.tab.redstoneBehaviour." + this.id;
        }
    }
}

