/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import java.lang.ref.WeakReference;
import java.util.BitSet;
import java.util.EnumMap;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;

class CachedTileNeighbours {
    private final BitSet known = new BitSet(6);
    private final EnumMap<Direction, WeakReference<TileEntity>> neighbours = new EnumMap(Direction.class);
    private final TileEntity owner;

    public CachedTileNeighbours(TileEntity owner) {
        this.owner = owner;
        for (Direction d : DirectionUtil.VALUES) {
            this.neighbours.put(d, new WeakReference<Object>(null));
        }
    }

    public TileEntity getCachedNeighbour(Direction dir) {
        TileEntity res;
        if (this.owner.func_145831_w() == null) {
            return null;
        }
        TileEntity tileEntity = res = this.known.get(dir.func_176745_a()) ? (TileEntity)this.neighbours.get(dir).get() : this.findNeighbour(dir);
        if (res != null && res.func_145837_r()) {
            res = this.findNeighbour(dir);
        }
        return res;
    }

    private TileEntity findNeighbour(Direction dir) {
        BlockPos pos2 = this.owner.func_174877_v().func_177972_a(dir);
        TileEntity te = this.owner.func_145831_w().isAreaLoaded(pos2, 0) ? this.owner.func_145831_w().func_175625_s(pos2) : null;
        this.neighbours.put(dir, new WeakReference<TileEntity>(te));
        this.known.set(dir.func_176745_a());
        return te;
    }

    public void purge() {
        this.known.clear();
    }
}

