/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.patchouli;

import com.google.gson.JsonElement;
import me.desht.pneumaticcraft.common.recipes.ModCraftingHelper;
import net.minecraft.fluid.Fluid;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import vazkii.patchouli.api.IVariableSerializer;

public class FluidStackVariableSerializer
implements IVariableSerializer<FluidStack> {
    public FluidStack fromJson(JsonElement json) {
        if (json.isJsonNull()) {
            return FluidStack.EMPTY;
        }
        if (json.isJsonPrimitive()) {
            return FluidStackVariableSerializer.fluidStackFromString(json.getAsString());
        }
        if (json.isJsonObject()) {
            return ModCraftingHelper.fluidStackFromJson(json.getAsJsonObject());
        }
        throw new IllegalArgumentException("Can't make an FluidStack from an array!");
    }

    public JsonElement toJson(FluidStack fluidStack) {
        return ModCraftingHelper.fluidStackToJson(fluidStack);
    }

    private static FluidStack fluidStackFromString(String s) {
        ResourceLocation fluidId;
        String id = s;
        int count = 1000;
        String[] split = s.split("#");
        if (split.length > 1) {
            id = split[0];
            count = Integer.parseInt(split[1]);
        }
        if (!ForgeRegistries.FLUIDS.containsKey(fluidId = new ResourceLocation(id))) {
            throw new RuntimeException("Unknown fluid: " + id);
        }
        Fluid f = (Fluid)ForgeRegistries.FLUIDS.getValue(fluidId);
        return new FluidStack(f, count);
    }
}

