/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.mekanism;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerAdapter;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.heat.HeatExchangerLogicAmbient;
import me.desht.pneumaticcraft.common.thirdparty.mekanism.MekanismIntegration;
import mekanism.api.heat.IHeatHandler;
import mekanism.common.tile.TileEntityQuantumEntangloporter;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.world.IWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class Mek2PNCHeatProvider
implements ICapabilityProvider {
    private final List<LazyOptional<IHeatExchangerLogic>> handlers = new ArrayList<LazyOptional<IHeatExchangerLogic>>();
    private final WeakReference<TileEntity> teRef;

    public Mek2PNCHeatProvider(TileEntity te) {
        this.teRef = new WeakReference<TileEntity>(te);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        TileEntity te;
        LazyOptional heatHandler;
        int idx;
        if (cap != PNCCapabilities.HEAT_EXCHANGER_CAPABILITY || this.teRef.get() == null || !((TileEntity)this.teRef.get()).getCapability(MekanismIntegration.CAPABILITY_HEAT_HANDLER, side).isPresent()) {
            return LazyOptional.empty();
        }
        if (this.handlers.isEmpty()) {
            for (int i = 0; i < 7; ++i) {
                this.handlers.add((LazyOptional<IHeatExchangerLogic>)LazyOptional.empty());
            }
        }
        int n = idx = side == null ? 6 : side.func_176745_a();
        if (!this.handlers.get(idx).isPresent() && (heatHandler = (te = (TileEntity)this.teRef.get()).getCapability(MekanismIntegration.CAPABILITY_HEAT_HANDLER, side)).isPresent()) {
            heatHandler.addListener(l -> this.handlers.set(idx, (LazyOptional<IHeatExchangerLogic>)LazyOptional.empty()));
            Mek2PNCHeatAdapter adapter = new Mek2PNCHeatAdapter(side, (LazyOptional<IHeatHandler>)heatHandler, HeatExchangerLogicAmbient.atPosition((IWorld)te.func_145831_w(), te.func_174877_v()).getAmbientTemperature(), this.getResistanceMultiplier(te));
            this.handlers.set(idx, (LazyOptional<IHeatExchangerLogic>)LazyOptional.of(() -> adapter));
        }
        return this.handlers.get(idx);
    }

    private double getResistanceMultiplier(TileEntity te) {
        if (te instanceof TileEntityTransmitter || te instanceof TileEntityQuantumEntangloporter) {
            return 1.0E7;
        }
        return 1.0;
    }

    public static class Mek2PNCHeatAdapter
    extends IHeatExchangerAdapter.Simple<IHeatHandler> {
        private final double thermalResistanceMult;

        public Mek2PNCHeatAdapter(Direction side, LazyOptional<IHeatHandler> heatHandler, double ambientTemperature, double thermalResistanceMult) {
            super(side, heatHandler, ambientTemperature);
            this.thermalResistanceMult = thermalResistanceMult;
        }

        @Override
        public double getTemperature() {
            return this.foreignHeatCap.map(h -> h.getTemperature(0)).orElse(0.0);
        }

        @Override
        public double getThermalResistance() {
            return this.foreignHeatCap.map(h -> h.getInverseConduction(0) * this.thermalResistanceMult).orElse(1.0);
        }

        @Override
        public double getThermalCapacity() {
            return this.foreignHeatCap.map(h -> h.getHeatCapacity(0)).orElse(0.0);
        }

        @Override
        public void addHeat(double amount) {
            if (amount > 0.0) {
                this.foreignHeatCap.ifPresent(h -> h.handleHeat(amount / (Double)ConfigHelper.common().integration.mekThermalEfficiencyFactor.get()));
            }
        }
    }
}

