/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.jei.transfer;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.client.gui.GuiProgrammer;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.inventory.ContainerProgrammer;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketProgrammerUpdate;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetCrafting;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetItemFilter;
import me.desht.pneumaticcraft.common.tileentity.TileEntityProgrammer;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.IGuiIngredient;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.runtime.IRecipesGui;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ProgrammerTransferHandler
implements IRecipeTransferHandler<ContainerProgrammer> {
    private static GuiProgrammer programmerScreen = null;
    private final IRecipeTransferHandlerHelper transferHelper;

    public ProgrammerTransferHandler(IRecipeTransferHandlerHelper transferHelper) {
        this.transferHelper = transferHelper;
    }

    public Class<ContainerProgrammer> getContainerClass() {
        return ContainerProgrammer.class;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(ContainerProgrammer container, Object recipe, IRecipeLayout recipeLayout, PlayerEntity player, boolean maxTransfer, boolean doTransfer) {
        if (programmerScreen != null) {
            IProgWidget craftingWidget = recipe instanceof ICraftingRecipe ? this.findSuitableCraftingWidget(programmerScreen) : null;
            List<ProgWidgetItemFilter> params = this.makeFilterWidgets(craftingWidget, recipe, recipeLayout, craftingWidget == null && !maxTransfer);
            if (params.isEmpty()) {
                return this.transferHelper.createInternalError();
            }
            if (doTransfer) {
                TileEntityProgrammer programmer = (TileEntityProgrammer)ProgrammerTransferHandler.programmerScreen.te;
                programmer.progWidgets.addAll(params);
                NetworkHandler.sendToServer(new PacketProgrammerUpdate(programmer));
                TileEntityProgrammer.updatePuzzleConnections(programmer.progWidgets);
            }
            return null;
        }
        return this.transferHelper.createInternalError();
    }

    private List<ProgWidgetItemFilter> makeFilterWidgets(IProgWidget craftingWidget, Object recipe, IRecipeLayout recipeLayout, boolean uniqueStacks) {
        PointXY base;
        IGuiItemStackGroup stacks = recipeLayout.getItemStacks();
        ArrayList<Object> l = new ArrayList<Object>();
        HashSet<Item> itemsSeen = new HashSet<Item>();
        for (IGuiIngredient ingr : stacks.getGuiIngredients().values()) {
            ItemStack stack;
            ItemStack itemStack = stack = ingr.getDisplayedIngredient() == null ? ItemStack.field_190927_a : (ItemStack)ingr.getDisplayedIngredient();
            if (!ingr.isInput() || !(recipe instanceof ShapedRecipe) && stack.func_190926_b()) continue;
            l.add(uniqueStacks && itemsSeen.contains(stack.func_77973_b()) ? ItemStack.field_190927_a : stack);
            itemsSeen.add(stack.func_77973_b());
        }
        if (recipe instanceof ShapedRecipe) {
            if (l.size() != 9) {
                return Collections.emptyList();
            }
            for (int n = 0; n < 2; ++n) {
                if (!((ItemStack)l.get(0)).func_190926_b() || !((ItemStack)l.get(3)).func_190926_b() || !((ItemStack)l.get(6)).func_190926_b()) continue;
                for (int i = 0; i < l.size(); ++i) {
                    if (i % 3 == 2) {
                        l.set(i, ItemStack.field_190927_a);
                        continue;
                    }
                    if (i + 1 >= l.size()) continue;
                    l.set(i, l.get(i + 1));
                }
            }
        }
        ProgWidgetItemFilter filterWidget = new ProgWidgetItemFilter();
        if (craftingWidget == null) {
            Rectangle2d bounds = programmerScreen.getProgrammerBounds();
            base = programmerScreen.mouseToWidgetCoords(programmerScreen.getGuiLeft() + bounds.func_199318_a() + 50, programmerScreen.getGuiTop() + bounds.func_199319_b() + 50, filterWidget);
        } else {
            base = new PointXY(craftingWidget.getX() + craftingWidget.getWidth() / 2, craftingWidget.getY());
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        int c = 0;
        for (int n = 0; n < l.size(); ++n) {
            ItemStack stack = (ItemStack)l.get(n);
            if (stack.func_190926_b() && (craftingWidget == null || n % 3 >= 2 || ((ItemStack)l.get(n + 1)).func_190926_b())) continue;
            ProgWidgetItemFilter w = ProgWidgetItemFilter.withFilter(stack);
            if (craftingWidget == null) {
                w.setX(base.x + c++ * filterWidget.getWidth() / 2);
                w.setY(base.y);
            } else {
                w.setX(base.x + n % 3 * filterWidget.getWidth() / 2);
                w.setY(base.y + n / 3 * filterWidget.getHeight() / 2);
            }
            builder.add((Object)w);
        }
        return builder.build();
    }

    private IProgWidget findSuitableCraftingWidget(GuiProgrammer guiProgrammer) {
        return ((TileEntityProgrammer)ProgrammerTransferHandler.programmerScreen.te).progWidgets.stream().filter(w -> w instanceof ProgWidgetCrafting && guiProgrammer.isVisible((IProgWidget)w)).filter(w -> w.getConnectedParameters()[0] == null && w.getConnectedParameters()[1] == null && w.getConnectedParameters()[2] == null).findFirst().orElse(null);
    }

    public static class Listener {
        @SubscribeEvent
        public static void onGuiOpen(GuiOpenEvent event) {
            if (event.getGui() instanceof IRecipesGui && Minecraft.func_71410_x().field_71462_r instanceof GuiProgrammer) {
                programmerScreen = (GuiProgrammer)Minecraft.func_71410_x().field_71462_r;
            } else if (!(event.getGui() instanceof IRecipesGui)) {
                programmerScreen = null;
            }
        }
    }
}

