/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.jei;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import me.desht.pneumaticcraft.api.crafting.ingredient.FluidIngredient;
import me.desht.pneumaticcraft.common.core.ModFluids;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.thirdparty.jei.AbstractPNCCategory;
import me.desht.pneumaticcraft.common.thirdparty.jei.ModCategoryUid;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.client.resources.I18n;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fluids.FluidStack;

public class JEIYeastCraftingCategory
extends AbstractPNCCategory<YeastCraftingRecipe> {
    public JEIYeastCraftingCategory() {
        super(ModCategoryUid.YEAST_CRAFTING, YeastCraftingRecipe.class, (ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.jei.title.yeastCrafting", new Object[0]), (IDrawable)JEIYeastCraftingCategory.guiHelper().createDrawable(Textures.GUI_JEI_YEAST_CRAFTING, 0, 0, 128, 40), JEIYeastCraftingCategory.guiHelper().createDrawableIngredient((Object)new ItemStack((IItemProvider)ModItems.YEAST_CULTURE_BUCKET.get())));
    }

    public void setIngredients(YeastCraftingRecipe recipe, IIngredients ingredients) {
        ingredients.setInput(VanillaTypes.ITEM, (Object)recipe.itemInput);
        ingredients.setInputs(VanillaTypes.FLUID, (List)ImmutableList.of((Object)new FluidStack((Fluid)ModFluids.YEAST_CULTURE.get(), 1000), (Object)new FluidStack((Fluid)Fluids.field_204546_a, 1000)));
        ingredients.setOutput(VanillaTypes.FLUID, (Object)recipe.output);
    }

    public void setRecipe(IRecipeLayout recipeLayout, YeastCraftingRecipe recipe, IIngredients ingredients) {
        recipeLayout.getItemStacks().init(0, true, 0, 0);
        recipeLayout.getItemStacks().set(0, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
        recipeLayout.getFluidStacks().init(0, true, 16, 16);
        recipeLayout.getFluidStacks().set(0, (List)ingredients.getInputs(VanillaTypes.FLUID).get(0));
        recipeLayout.getFluidStacks().init(1, true, 32, 16);
        recipeLayout.getFluidStacks().set(1, (List)ingredients.getInputs(VanillaTypes.FLUID).get(1));
        recipeLayout.getFluidStacks().init(2, false, 80, 16);
        recipeLayout.getFluidStacks().set(2, (List)ingredients.getOutputs(VanillaTypes.FLUID).get(0));
        recipeLayout.getFluidStacks().init(3, false, 96, 16);
        recipeLayout.getFluidStacks().set(3, (List)ingredients.getOutputs(VanillaTypes.FLUID).get(0));
    }

    public static Collection<?> getAllRecipes() {
        return Collections.singletonList(new YeastCraftingRecipe(new ItemStack((IItemProvider)Items.field_151102_aT), FluidIngredient.of(1000, (Fluid)ModFluids.YEAST_CULTURE.get()), new FluidStack((Fluid)ModFluids.YEAST_CULTURE.get(), 1000)));
    }

    public List<ITextComponent> getTooltipStrings(YeastCraftingRecipe recipe, double mouseX, double mouseY) {
        ArrayList<ITextComponent> res = new ArrayList<ITextComponent>();
        if (mouseX >= 48.0 && mouseX <= 80.0) {
            res.addAll(PneumaticCraftUtils.splitStringComponent(I18n.func_135052_a((String)"pneumaticcraft.gui.jei.tooltip.yeastCrafting", (Object[])new Object[0])));
        }
        return res;
    }

    static class YeastCraftingRecipe {
        final ItemStack itemInput;
        final FluidIngredient fluidInput;
        final FluidStack output;

        YeastCraftingRecipe(ItemStack itemInput, FluidIngredient fluidInput, FluidStack output) {
            this.itemInput = itemInput;
            this.fluidInput = fluidInput;
            this.output = output;
        }
    }
}

