/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.gamestages;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import me.desht.pneumaticcraft.api.misc.IPlayerMatcher;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.darkhax.gamestages.GameStageHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.apache.commons.lang3.Validate;

public class GamestagesMatcher
implements IPlayerMatcher {
    private final Set<String> stages;
    private final boolean matchAll;

    public GamestagesMatcher(Collection<String> stages, boolean matchAll) {
        stages.forEach(s -> Validate.isTrue((boolean)GameStageHelper.isStageKnown((String)s), (String)("unknown gamestage '" + s + "'!"), (Object[])new Object[0]));
        this.stages = ImmutableSet.copyOf(stages);
        this.matchAll = matchAll;
    }

    @Override
    public void toBytes(PacketBuffer buffer) {
        buffer.writeBoolean(this.matchAll);
        buffer.func_150787_b(this.stages.size());
        this.stages.forEach(arg_0 -> ((PacketBuffer)buffer).func_180714_a(arg_0));
    }

    @Override
    public JsonElement toJson() {
        JsonObject json = new JsonObject();
        JsonArray array = new JsonArray();
        this.stages.forEach(arg_0 -> ((JsonArray)array).add(arg_0));
        json.add(this.matchAll ? "all" : "any", (JsonElement)array);
        return json;
    }

    @Override
    public void addDescription(PlayerEntity player, List<ITextComponent> tooltip) {
        if (!this.stages.isEmpty()) {
            IFormattableTextComponent header = PneumaticCraftUtils.xlate("pneumaticcraft.playerFilter.gamestages", new Object[0]).func_240702_b_(" (").func_230529_a_((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.misc." + (this.matchAll ? "all" : "any"), new Object[0])).func_240702_b_(")");
            List<ITextComponent> items = this.stages.stream().map(StringTextComponent::new).collect(Collectors.toList());
            this.standardTooltip(player, tooltip, (ITextComponent)header, items);
        }
    }

    @Override
    public boolean test(PlayerEntity playerEntity) {
        return this.matchAll ? GameStageHelper.hasAllOf((PlayerEntity)playerEntity, this.stages) : GameStageHelper.hasAnyOf((PlayerEntity)playerEntity, this.stages);
    }

    public static class Factory
    implements IPlayerMatcher.MatcherFactory<GamestagesMatcher> {
        @Override
        public GamestagesMatcher fromJson(JsonElement json) {
            if (!json.isJsonObject()) {
                throw new JsonSyntaxException("expected JSON object here!");
            }
            JsonObject o = json.getAsJsonObject();
            if (o.has("any")) {
                return new GamestagesMatcher(this.getStrings(o, "any"), false);
            }
            if (o.has("all")) {
                return new GamestagesMatcher(this.getStrings(o, "all"), true);
            }
            throw new JsonSyntaxException("element must contain one of 'all' or 'any'");
        }

        private Collection<String> getStrings(JsonObject o, String fieldName) {
            return Streams.stream((Iterator)JSONUtils.func_151214_t((JsonObject)o, (String)fieldName).iterator()).map(JsonElement::getAsString).collect(Collectors.toList());
        }

        @Override
        public GamestagesMatcher fromBytes(PacketBuffer buffer) {
            boolean matchAll = buffer.readBoolean();
            int n = buffer.func_150792_a();
            ArrayList<String> l = new ArrayList<String>();
            for (int i = 0; i < n; ++i) {
                l.add(buffer.func_150789_c(64));
            }
            return new GamestagesMatcher(l, matchAll);
        }
    }
}

