/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.machine;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.crafting.recipe.PressureChamberRecipe;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.core.ModRecipes;
import me.desht.pneumaticcraft.common.recipes.machine.PressureChamberRecipeImpl;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.IItemHandler;

public class PressureDisenchantingRecipe
extends PressureChamberRecipeImpl {
    public static final ResourceLocation ID = PneumaticRegistry.RL("pressure_chamber_disenchanting");

    public PressureDisenchantingRecipe(ResourceLocation id) {
        super(id, Collections.emptyList(), -0.75f, new ItemStack[0]);
    }

    @Override
    public Collection<Integer> findIngredients(@Nonnull IItemHandler chamberHandler) {
        int bookSlot = -1;
        int itemSlot = -1;
        for (int i = 0; i < chamberHandler.getSlots(); ++i) {
            ItemStack stack = chamberHandler.getStackInSlot(i);
            if (stack.func_77973_b() == Items.field_151122_aG) {
                bookSlot = i;
            } else {
                int minEnchantments;
                int n = minEnchantments = stack.func_77973_b() == Items.field_151134_bR ? 2 : 1;
                if (!this.blacklisted(stack) && EnchantmentHelper.func_82781_a((ItemStack)stack).size() >= minEnchantments) {
                    itemSlot = i;
                }
            }
            if (bookSlot < 0 || itemSlot < 0) continue;
            return ImmutableList.of((Object)bookSlot, (Object)itemSlot);
        }
        return Collections.emptyList();
    }

    @Override
    public NonNullList<ItemStack> craftRecipe(@Nonnull IItemHandler chamberHandler, List<Integer> ingredientSlots, boolean simulate) {
        ItemStack book = chamberHandler.extractItem(ingredientSlots.get(0).intValue(), 1, simulate);
        ItemStack enchantedStack = chamberHandler.extractItem(ingredientSlots.get(1).intValue(), 1, simulate);
        if (book.func_190926_b() || enchantedStack.func_190926_b()) {
            return NonNullList.func_191196_a();
        }
        Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)enchantedStack);
        ArrayList l = new ArrayList(enchantments.keySet());
        Enchantment strippedEnchantment = (Enchantment)l.get(ThreadLocalRandom.current().nextInt(l.size()));
        int level = (Integer)enchantments.get(strippedEnchantment);
        enchantments.remove(strippedEnchantment);
        if (enchantedStack.func_77973_b() == Items.field_151134_bR) {
            enchantedStack = new ItemStack((IItemProvider)Items.field_151134_bR);
        }
        EnchantmentHelper.func_82782_a((Map)enchantments, (ItemStack)enchantedStack);
        ItemStack enchantedBook = new ItemStack((IItemProvider)Items.field_151134_bR);
        EnchantmentHelper.func_82782_a((Map)ImmutableMap.of((Object)strippedEnchantment, (Object)level), (ItemStack)enchantedBook);
        return NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])new ItemStack[]{enchantedBook, enchantedStack});
    }

    @Override
    public List<Ingredient> getInputsForDisplay() {
        ItemStack pick = new ItemStack((IItemProvider)Items.field_151046_w);
        pick.func_77966_a(Enchantments.field_185308_t, 1);
        ItemStack enchantedBook = new ItemStack((IItemProvider)Items.field_151134_bR);
        enchantedBook.func_77966_a(Enchantments.field_185308_t, 1);
        enchantedBook.func_77966_a(Enchantments.field_185305_q, 1);
        return ImmutableList.of((Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{pick, enchantedBook}), (Object)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151122_aG}));
    }

    @Override
    public List<List<ItemStack>> getResultsForDisplay() {
        ItemStack pick = new ItemStack((IItemProvider)Items.field_151046_w);
        ItemStack enchantedBook = new ItemStack((IItemProvider)Items.field_151134_bR);
        enchantedBook.func_77966_a(Enchantments.field_185305_q, 1);
        ItemStack resultBook = new ItemStack((IItemProvider)Items.field_151134_bR);
        resultBook.func_77966_a(Enchantments.field_185308_t, 1);
        return ImmutableList.of((Object)ImmutableList.of((Object)pick, (Object)enchantedBook), (Object)ImmutableList.of((Object)resultBook));
    }

    @Override
    public List<Set<PressureChamberRecipe.RecipeSlot>> getSyncGroupsForDisplay() {
        return ImmutableList.of((Object)ImmutableSet.of((Object)new PressureChamberRecipe.RecipeSlot(true, 0), (Object)new PressureChamberRecipe.RecipeSlot(false, 0)));
    }

    @Override
    public boolean isValidInputItem(ItemStack stack) {
        return stack.func_77973_b() == Items.field_151122_aG || stack.func_77973_b() != Items.field_151134_bR && EnchantmentHelper.func_82781_a((ItemStack)stack).size() > 0;
    }

    @Override
    public String getTooltipKey(boolean input, int slot) {
        switch (slot) {
            case 0: {
                return "pneumaticcraft.gui.nei.tooltip.vacuumEnchantItem";
            }
            case 2: {
                return "pneumaticcraft.gui.nei.tooltip.vacuumEnchantItemOut";
            }
            case 3: {
                return "pneumaticcraft.gui.nei.tooltip.vacuumEnchantBookOut";
            }
        }
        return "";
    }

    @Override
    public void write(PacketBuffer buffer) {
    }

    @Override
    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ModRecipes.PRESSURE_CHAMBER_DISENCHANTING.get();
    }

    private boolean blacklisted(ItemStack stack) {
        if (stack.func_77973_b().getRegistryName() != null) {
            String name = stack.func_77973_b().getRegistryName().toString();
            return ((List)ConfigHelper.common().machines.disenchantingBlacklist.get()).stream().anyMatch(name::startsWith);
        }
        return false;
    }
}

