/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.pneumatic_armor.handlers;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.api.pneumatic_armor.BaseArmorUpgradeHandler;
import me.desht.pneumaticcraft.api.pneumatic_armor.IArmorExtensionData;
import me.desht.pneumaticcraft.api.pneumatic_armor.ICommonArmorHandler;
import me.desht.pneumaticcraft.api.pressure.PressureHelper;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.core.ModSounds;
import me.desht.pneumaticcraft.common.item.ItemPneumaticArmor;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketPlaySound;
import me.desht.pneumaticcraft.common.network.PacketSpawnParticle;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;

public class ScubaHandler
extends BaseArmorUpgradeHandler<IArmorExtensionData> {
    @Override
    public ResourceLocation getID() {
        return PneumaticRegistry.RL("scuba");
    }

    @Override
    public EnumUpgrade[] getRequiredUpgrades() {
        return new EnumUpgrade[]{EnumUpgrade.SCUBA};
    }

    @Override
    public float getIdleAirUsage(ICommonArmorHandler armorHandler) {
        return 0.0f;
    }

    @Override
    public EquipmentSlotType getEquipmentSlot() {
        return EquipmentSlotType.HEAD;
    }

    @Override
    public void tick(ICommonArmorHandler commonArmorHandler, boolean enabled) {
        PlayerEntity player = commonArmorHandler.getPlayer();
        if (!player.field_70170_p.field_72995_K && enabled && commonArmorHandler.hasMinPressure(EquipmentSlotType.HEAD) && player.func_70086_ai() < 150) {
            ItemStack helmetStack = player.func_184582_a(EquipmentSlotType.HEAD);
            int baseVol = ((ItemPneumaticArmor)helmetStack.func_77973_b()).getBaseVolume();
            int vol = PressureHelper.getUpgradedVolume(baseVol, commonArmorHandler.getUpgradeCount(EquipmentSlotType.HEAD, EnumUpgrade.VOLUME));
            float airInHelmet = commonArmorHandler.getArmorPressure(EquipmentSlotType.HEAD) * (float)vol;
            int playerAir = (int)Math.min((float)(300 - player.func_70086_ai()), airInHelmet / (float)((Integer)ConfigHelper.common().armor.scubaMultiplier.get()).intValue());
            player.func_70050_g(player.func_70086_ai() + playerAir);
            int airUsed = playerAir * (Integer)ConfigHelper.common().armor.scubaMultiplier.get();
            commonArmorHandler.addAir(EquipmentSlotType.HEAD, -airUsed);
            NetworkHandler.sendToPlayer(new PacketPlaySound((SoundEvent)ModSounds.SCUBA.get(), SoundCategory.PLAYERS, player.func_233580_cy_(), 1.0f, 1.0f, false), (ServerPlayerEntity)player);
            Vector3d eyes = player.func_174824_e(1.0f).func_178787_e(player.func_70040_Z().func_186678_a(0.5));
            NetworkHandler.sendToAllTracking(new PacketSpawnParticle((IParticleData)ParticleTypes.field_197612_e, eyes.field_72450_a - 0.5, eyes.field_72448_b, eyes.field_72449_c - 0.5, 0.0, 0.2, 0.0, 10, 1.0, 1.0, 1.0), player.field_70170_p, player.func_233580_cy_());
        }
    }
}

