/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.pneumatic_armor.handlers;

import java.util.List;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.api.pneumatic_armor.BaseArmorUpgradeHandler;
import me.desht.pneumaticcraft.api.pneumatic_armor.IArmorExtensionData;
import me.desht.pneumaticcraft.api.pneumatic_armor.ICommonArmorHandler;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.item.ItemRegistry;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;

public class MagnetHandler
extends BaseArmorUpgradeHandler<IArmorExtensionData> {
    @Override
    public ResourceLocation getID() {
        return PneumaticRegistry.RL("magnet");
    }

    @Override
    public EnumUpgrade[] getRequiredUpgrades() {
        return new EnumUpgrade[]{EnumUpgrade.MAGNET};
    }

    @Override
    public int getMaxInstallableUpgrades(EnumUpgrade upgrade) {
        return 6;
    }

    @Override
    public float getIdleAirUsage(ICommonArmorHandler armorHandler) {
        return 0.0f;
    }

    @Override
    public EquipmentSlotType getEquipmentSlot() {
        return EquipmentSlotType.CHEST;
    }

    @Override
    public void tick(ICommonArmorHandler commonArmorHandler, boolean enabled) {
        PlayerEntity player = commonArmorHandler.getPlayer();
        if (player.field_70170_p.field_72995_K || !enabled || (player.field_70170_p.func_82737_E() & 3L) != 0L || !commonArmorHandler.hasMinPressure(EquipmentSlotType.CHEST)) {
            return;
        }
        int magnetRadius = 4 + Math.min(commonArmorHandler.getUpgradeCount(EquipmentSlotType.CHEST, EnumUpgrade.MAGNET), 6);
        int magnetRadiusSq = magnetRadius * magnetRadius;
        AxisAlignedBB box = new AxisAlignedBB(player.func_233580_cy_()).func_186662_g((double)magnetRadius);
        List itemList = player.func_130014_f_().func_175647_a(Entity.class, box, e -> (e instanceof ExperienceOrbEntity || e instanceof ItemEntity) && e.func_70089_S());
        Vector3d playerVec = player.func_213303_ch();
        for (Entity item : itemList) {
            if (item instanceof ItemEntity && ((ItemEntity)item).func_174874_s() || !(item.func_213303_ch().func_72436_e(playerVec) <= (double)magnetRadiusSq) || ItemRegistry.getInstance().shouldSuppressMagnet(item) || item.getPersistentData().func_74767_n("PreventRemoteMovement")) continue;
            if (!commonArmorHandler.hasMinPressure(EquipmentSlotType.CHEST)) break;
            item.func_70107_b(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_());
            if (item instanceof ItemEntity) {
                ((ItemEntity)item).func_174867_a(0);
            }
            commonArmorHandler.addAir(EquipmentSlotType.CHEST, -((Integer)ConfigHelper.common().armor.magnetAirUsage.get()).intValue());
        }
    }
}

