/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.function.Supplier;
import me.desht.pneumaticcraft.common.network.PacketUtil;
import me.desht.pneumaticcraft.common.tileentity.IGUITextFieldSensitive;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketUpdateTextfield {
    private final int textFieldID;
    private final String text;

    public PacketUpdateTextfield(TileEntity te, int textfieldID) {
        this.textFieldID = textfieldID;
        this.text = ((IGUITextFieldSensitive)te).getText(textfieldID);
    }

    public PacketUpdateTextfield(PacketBuffer buffer) {
        this.textFieldID = buffer.readInt();
        this.text = buffer.func_150789_c(Short.MAX_VALUE);
    }

    public void toBytes(PacketBuffer buffer) {
        buffer.writeInt(this.textFieldID);
        buffer.func_180714_a(this.text);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> PacketUtil.getTE((PlayerEntity)((NetworkEvent.Context)ctx.get()).getSender(), TileEntity.class).ifPresent(te -> {
            if (te instanceof IGUITextFieldSensitive) {
                ((IGUITextFieldSensitive)te).setText(this.textFieldID, this.text);
            }
        }));
        ctx.get().setPacketHandled(true);
    }
}

