/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.function.Supplier;
import me.desht.pneumaticcraft.common.block.tubes.INetworkedModule;
import me.desht.pneumaticcraft.common.block.tubes.TubeModule;
import me.desht.pneumaticcraft.common.network.LocationIntPacket;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPressureTube;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketTubeModuleColor
extends LocationIntPacket {
    private final int ourColor;
    private final Direction side;

    public PacketTubeModuleColor(TubeModule module) {
        super(module.getTube().func_174877_v());
        this.ourColor = ((INetworkedModule)((Object)module)).getColorChannel();
        this.side = module.getDirection();
    }

    PacketTubeModuleColor(PacketBuffer buffer) {
        super(buffer);
        this.ourColor = buffer.readByte();
        this.side = Direction.func_82600_a((int)buffer.readByte());
    }

    @Override
    public void toBytes(PacketBuffer buf) {
        super.toBytes(buf);
        buf.writeByte(this.ourColor);
        buf.writeByte(this.side.func_176745_a());
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null) {
                PneumaticCraftUtils.getTileEntityAt((IBlockReader)player.field_70170_p, this.pos, TileEntityPressureTube.class).ifPresent(te -> {
                    TubeModule module = te.getModule(this.side);
                    if (module instanceof INetworkedModule) {
                        ((INetworkedModule)((Object)module)).setColorChannel(this.ourColor);
                    }
                });
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

