/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.common.network.ILargePayload;
import me.desht.pneumaticcraft.common.network.LocationIntPacket;
import me.desht.pneumaticcraft.common.network.PacketUtil;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.tileentity.TileEntityProgrammer;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketProgrammerUpdate
extends LocationIntPacket
implements ILargePayload {
    private final List<IProgWidget> widgets;

    public PacketProgrammerUpdate(TileEntityProgrammer te) {
        super(te.func_174877_v());
        this.widgets = te.progWidgets;
    }

    public PacketProgrammerUpdate(PacketBuffer buffer) {
        super(buffer);
        this.widgets = PacketProgrammerUpdate.readWidgetsFromPacket(buffer);
    }

    @Override
    public void toBytes(PacketBuffer buffer) {
        super.toBytes(buffer);
        this.writeProgWidgetsToPacket(buffer);
    }

    private void writeProgWidgetsToPacket(PacketBuffer buf) {
        buf.func_150787_b(this.widgets.size());
        for (IProgWidget progWidget : this.widgets) {
            progWidget.writeToPacket(buf);
        }
    }

    private static List<IProgWidget> readWidgetsFromPacket(PacketBuffer buf) {
        ArrayList<IProgWidget> widgets = new ArrayList<IProgWidget>();
        int nWidgets = buf.func_150792_a();
        for (int i = 0; i < nWidgets; ++i) {
            try {
                IProgWidget widget = ProgWidget.fromPacket(buf);
                if (!widget.isAvailable()) {
                    Log.warning("ignoring unavailable widget type " + widget.getTypeID().toString(), new Object[0]);
                    continue;
                }
                widgets.add(widget);
                continue;
            }
            catch (IllegalStateException e) {
                Log.warning(e.getMessage(), new Object[0]);
            }
        }
        return widgets;
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> this.updateTE((PlayerEntity)((NetworkEvent.Context)ctx.get()).getSender()));
        ctx.get().setPacketHandled(true);
    }

    private void updateTE(PlayerEntity player) {
        PacketUtil.getTE(player, this.pos, TileEntityProgrammer.class).ifPresent(te -> te.setProgWidgets(this.widgets, player));
    }

    @Override
    public PacketBuffer dumpToBuffer() {
        PacketBuffer buf = new PacketBuffer(Unpooled.buffer());
        this.toBytes(buf);
        return buf;
    }

    @Override
    public void handleLargePayload(PlayerEntity player) {
        this.updateTE(player);
    }
}

