/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.item.ISpawnerCoreStats;
import me.desht.pneumaticcraft.api.misc.Symbols;
import me.desht.pneumaticcraft.client.ColorHandlers;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.TintColor;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemSpawnerCore
extends Item
implements ColorHandlers.ITintableItem {
    private static final String NBT_SPAWNER_CORE = "pneumaticcraft:SpawnerCoreStats";

    public ItemSpawnerCore() {
        super(ModItems.defaultProps());
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        SpawnerCoreStats stats = SpawnerCoreStats.forItemStack(stack);
        if (stats != null) {
            if (stats.getUnusedPercentage() < 100) {
                stats.getEntities().stream().sorted(Comparator.comparing(t -> I18n.func_135052_a((String)t.func_210760_d(), (Object[])new Object[0]))).forEach(type -> tooltip.add((ITextComponent)Symbols.bullet().func_230529_a_((ITextComponent)PneumaticCraftUtils.xlate(type.func_210760_d(), new Object[0]).func_240699_a_(TextFormatting.YELLOW)).func_240702_b_(": " + stats.getPercentage((EntityType<?>)type) + "%").func_240699_a_(TextFormatting.WHITE)));
                if (stats.getUnusedPercentage() > 0) {
                    tooltip.add((ITextComponent)Symbols.bullet().func_230529_a_((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.misc.empty", new Object[0]).func_240701_a_(new TextFormatting[]{TextFormatting.YELLOW, TextFormatting.ITALIC})).func_240702_b_(": " + stats.getUnusedPercentage() + "%").func_240699_a_(TextFormatting.WHITE));
                }
            } else {
                tooltip.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.misc.empty", new Object[0]).func_240699_a_(TextFormatting.YELLOW));
            }
        }
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        if (!context.func_195991_k().field_72995_K) {
            return this.trySpawnEntity(context) ? ActionResultType.CONSUME : ActionResultType.PASS;
        }
        return ActionResultType.SUCCESS;
    }

    private boolean trySpawnEntity(ItemUseContext context) {
        ItemStack stack = context.func_195996_i();
        if (stack.func_190916_E() != 1) {
            return false;
        }
        SpawnerCoreStats stats = SpawnerCoreStats.forItemStack(stack);
        if (stats != null) {
            Vector3d vec;
            World world = context.func_195991_k();
            EntityType<?> type = stats.pickEntity(false);
            if (type != null && type.getRegistryName() != null && world.func_226664_a_(type.func_220328_a((vec = context.func_221532_j()).func_82615_a(), vec.func_82617_b(), vec.func_82616_c()))) {
                ServerWorld serverworld = (ServerWorld)world;
                CompoundNBT nbt = new CompoundNBT();
                nbt.func_74778_a("id", type.getRegistryName().toString());
                Entity entity = EntityType.func_220335_a((CompoundNBT)nbt, (World)world, e1 -> {
                    e1.func_70012_b(vec.func_82615_a(), vec.func_82617_b(), vec.func_82616_c(), e1.field_70177_z, e1.field_70125_A);
                    return e1;
                });
                if (entity != null) {
                    entity.func_70012_b(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), world.field_73012_v.nextFloat() * 360.0f, 0.0f);
                    if (serverworld.func_242106_g(entity)) {
                        stats.addAmount(type, -1);
                        stats.serialize(stack);
                        return true;
                    }
                }
            }
        }
        return false;
    }

    @Override
    public int getTintColor(ItemStack stack, int tintIndex) {
        SpawnerCoreStats stats;
        if (tintIndex == 1 && (stats = SpawnerCoreStats.forItemStack(stack)) != null) {
            if (stats.getUnusedPercentage() == 100) {
                return -1;
            }
            int t = (int)(ClientUtils.getClientWorld().func_82737_E() % 40L);
            float b = t < 20 ? MathHelper.func_76126_a((float)((float)Math.PI * (float)t / 20.0f)) / 6.0f : 0.0f;
            return TintColor.HSBtoRGB(0.19722222f, 1.0f - (float)stats.getUnusedPercentage() / 100.0f, 0.83333f + b);
        }
        return -1;
    }

    public static class SpawnerCoreItemHandler
    extends BaseItemStackHandler {
        private ISpawnerCoreStats stats;

        public SpawnerCoreItemHandler(TileEntity owner) {
            super(owner, 1);
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return stack.func_77973_b() instanceof ItemSpawnerCore;
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (slot == 0) {
                this.readSpawnerCoreStats();
            }
        }

        public void deserializeNBT(CompoundNBT nbt) {
            super.deserializeNBT(nbt);
            this.readSpawnerCoreStats();
        }

        public ISpawnerCoreStats getStats() {
            return this.stats;
        }

        private void readSpawnerCoreStats() {
            this.stats = this.getStackInSlot(0).func_190926_b() ? null : SpawnerCoreStats.forItemStack(this.getStackInSlot(0));
        }
    }

    public static class SpawnerCoreStats
    implements ISpawnerCoreStats {
        private final Map<EntityType<?>, Integer> entityCounts = new HashMap();
        private int unused;

        private SpawnerCoreStats(ItemStack stack) {
            CompoundNBT nbt0 = stack.func_77978_p();
            int total = 0;
            if (nbt0 != null && nbt0.func_74764_b(ItemSpawnerCore.NBT_SPAWNER_CORE)) {
                CompoundNBT nbt = nbt0.func_74775_l(ItemSpawnerCore.NBT_SPAWNER_CORE);
                for (String k : nbt.func_150296_c()) {
                    EntityType type = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(k));
                    if (type == null) continue;
                    int amount = nbt.func_74762_e(k);
                    this.entityCounts.put(type, amount);
                    total += amount;
                }
            }
            this.unused = Math.max(0, 100 - total);
        }

        static SpawnerCoreStats forItemStack(ItemStack stack) {
            return stack.func_77973_b() instanceof ItemSpawnerCore ? new SpawnerCoreStats(stack) : null;
        }

        @Override
        public void serialize(ItemStack stack) {
            if (stack.func_77973_b() instanceof ItemSpawnerCore) {
                if (this.unused == 100) {
                    CompoundNBT tag = stack.func_77978_p();
                    if (tag != null) {
                        tag.func_82580_o(ItemSpawnerCore.NBT_SPAWNER_CORE);
                    }
                } else {
                    CompoundNBT subTag = stack.func_190925_c(ItemSpawnerCore.NBT_SPAWNER_CORE);
                    this.entityCounts.forEach((type, amount) -> {
                        if (type.getRegistryName() != null) {
                            if (amount > 0) {
                                subTag.func_74768_a(type.getRegistryName().toString(), amount.intValue());
                            } else {
                                subTag.func_82580_o(type.getRegistryName().toString());
                            }
                        }
                    });
                }
            } else {
                throw new IllegalArgumentException("item is not a spawner core!");
            }
        }

        @Override
        public Set<EntityType<?>> getEntities() {
            return this.entityCounts.keySet();
        }

        @Override
        public int getPercentage(EntityType<?> entityType) {
            return this.entityCounts.getOrDefault(entityType, 0);
        }

        @Override
        public int getUnusedPercentage() {
            return this.unused;
        }

        @Override
        public boolean addAmount(EntityType<?> type, int toAdd) {
            int current = this.entityCounts.getOrDefault(type, 0);
            if ((toAdd = MathHelper.func_76125_a((int)toAdd, (int)(-current), (int)this.unused)) != 0) {
                int newAmount = MathHelper.func_76125_a((int)(current + toAdd), (int)0, (int)100);
                this.entityCounts.put(type, newAmount);
                this.unused -= toAdd;
                return true;
            }
            return false;
        }

        @Override
        public EntityType<?> pickEntity(boolean includeUnused) {
            if (this.unused == 100) {
                return null;
            }
            ArrayList<WeightedEntity> weightedEntities = new ArrayList<WeightedEntity>();
            this.entityCounts.forEach((type, amount) -> weightedEntities.add(new WeightedEntity((EntityType<?>)type, (int)amount)));
            if (includeUnused) {
                weightedEntities.add(new WeightedEntity(null, this.unused));
            }
            return ((WeightedEntity)WeightedRandom.func_76271_a((Random)ThreadLocalRandom.current(), weightedEntities)).type;
        }

        private static class WeightedEntity
        extends WeightedRandom.Item {
            private final EntityType<?> type;

            public WeightedEntity(EntityType<?> type, int itemWeightIn) {
                super(itemWeightIn);
                this.type = type;
            }
        }
    }
}

