/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import java.util.List;
import java.util.Locale;
import me.desht.pneumaticcraft.client.gui.GuiMicromissile;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.config.subconfig.MicromissileDefaults;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.entity.projectile.EntityMicromissile;
import me.desht.pneumaticcraft.common.util.ITranslatableEnum;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.RayTraceUtils;
import net.minecraft.block.Blocks;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.Validate;

public class ItemMicromissiles
extends Item {
    public static final String NBT_TOP_SPEED = "topSpeed";
    public static final String NBT_TURN_SPEED = "turnSpeed";
    public static final String NBT_DAMAGE = "damage";
    public static final String NBT_FILTER = "filter";
    public static final String NBT_PX = "px";
    public static final String NBT_PY = "py";
    public static final String NBT_FIRE_MODE = "fireMode";

    public ItemMicromissiles() {
        super(ModItems.defaultProps().func_200917_a(1).func_200915_b(100));
    }

    public int getMaxDamage(ItemStack stack) {
        return (Integer)ConfigHelper.common().micromissiles.missilePodSize.get();
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return toRepair.func_77973_b() == this && repair.func_77973_b() == Blocks.field_150335_W.func_199767_j();
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (playerIn.func_225608_bj_()) {
            if (worldIn.field_72995_K) {
                GuiMicromissile.openGui(stack.func_200301_q(), handIn);
            }
            return ActionResult.func_226248_a_((Object)stack);
        }
        EntityMicromissile missile = new EntityMicromissile(worldIn, (LivingEntity)playerIn, stack);
        Vector3d newPos = missile.func_213303_ch().func_178787_e(playerIn.func_70040_Z().func_72432_b());
        missile.func_70107_b(newPos.field_72450_a, newPos.field_72448_b, newPos.field_72449_c);
        missile.func_234612_a_((Entity)playerIn, playerIn.field_70125_A, playerIn.field_70177_z, 0.0f, this.getInitialVelocity(stack), 0.0f);
        playerIn.func_184811_cZ().func_185145_a((Item)this, ((Integer)ConfigHelper.common().micromissiles.launchCooldown.get()).intValue());
        if (!worldIn.field_72995_K) {
            EntityRayTraceResult ertr;
            RayTraceResult res = RayTraceUtils.getMouseOverServer((LivingEntity)playerIn, 100.0);
            if (res instanceof EntityRayTraceResult && missile.isValidTarget((ertr = (EntityRayTraceResult)res).func_216348_a())) {
                missile.setTarget(ertr.func_216348_a());
            }
            worldIn.func_217376_c((Entity)missile);
        }
        if (!playerIn.func_184812_l_()) {
            stack.func_222118_a(1, (LivingEntity)playerIn, playerEntity -> {});
        }
        return ActionResult.func_226248_a_((Object)stack);
    }

    private float getInitialVelocity(ItemStack stack) {
        if (stack.func_77942_o()) {
            CompoundNBT tag = stack.func_77978_p();
            FireMode fireMode = FireMode.fromString(tag.func_74779_i(NBT_FIRE_MODE));
            if (fireMode == FireMode.SMART) {
                return Math.max(0.2f, tag.func_74760_g(NBT_TOP_SPEED) / 2.0f);
            }
            return 0.33333334f;
        }
        return 0.33333334f;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> curInfo, ITooltipFlag extraInfo) {
        super.func_77624_a(stack, worldIn, curInfo, extraInfo);
        curInfo.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.micromissile.remaining", new Object[0]).func_230529_a_((ITextComponent)new StringTextComponent(Integer.toString(stack.func_77958_k() - stack.func_77952_i())).func_240699_a_(TextFormatting.AQUA)));
        if (stack.func_77942_o()) {
            FireMode mode = ItemMicromissiles.getFireMode(stack);
            if (mode == FireMode.SMART) {
                CompoundNBT tag = stack.func_77978_p();
                curInfo.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.micromissile.topSpeed", new Object[0]));
                curInfo.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.micromissile.turnSpeed", new Object[0]));
                curInfo.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.micromissile.damage", new Object[0]));
                String filter = tag.func_74779_i(NBT_FILTER);
                if (!filter.isEmpty()) {
                    curInfo.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.sentryTurret.targetFilter", new Object[0]).func_240702_b_(": ").func_240702_b_(TextFormatting.AQUA + filter));
                }
            }
            curInfo.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.micromissile.firingMode", new Object[0]).func_240702_b_(": ").func_230529_a_((ITextComponent)PneumaticCraftUtils.xlate(mode.getTranslationKey(), new Object[0]).func_240699_a_(TextFormatting.AQUA)));
            if (((Boolean)ConfigHelper.common().micromissiles.damageTerrain.get()).booleanValue()) {
                curInfo.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.terrainWarning", new Object[0]));
            } else {
                curInfo.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.terrainSafe", new Object[0]));
            }
        }
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        MicromissileDefaults.Entry def;
        if (!stack.func_77942_o() && entityIn instanceof PlayerEntity && (def = MicromissileDefaults.INSTANCE.getDefaults((PlayerEntity)entityIn)) != null) {
            stack.func_77982_d(def.toNBT());
        }
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public static FireMode getFireMode(ItemStack stack) {
        Validate.isTrue((boolean)(stack.func_77973_b() instanceof ItemMicromissiles));
        return stack.func_77942_o() ? FireMode.fromString(stack.func_77978_p().func_74779_i(NBT_FIRE_MODE)) : FireMode.SMART;
    }

    @Mod.EventBusSubscriber(modid="pneumaticcraft")
    public static class Listener {
        @SubscribeEvent
        public static void onMissilesRepair(AnvilRepairEvent event) {
            if (event.getItemResult().func_77973_b() instanceof ItemMicromissiles && event.getItemResult().func_77942_o()) {
                event.getItemResult().func_82841_c(0);
            }
        }
    }

    public static enum FireMode implements ITranslatableEnum
    {
        SMART,
        DUMB;


        public static FireMode fromString(String mode) {
            try {
                return FireMode.valueOf(mode);
            }
            catch (IllegalArgumentException e) {
                return SMART;
            }
        }

        @Override
        public String getTranslationKey() {
            return "pneumaticcraft.gui.micromissile.mode." + this.toString().toLowerCase(Locale.ROOT);
        }
    }
}

