/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.inventory;

import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.common.core.ModContainers;
import me.desht.pneumaticcraft.common.entity.semiblock.EntityLogisticsFrame;
import me.desht.pneumaticcraft.common.inventory.ContainerPneumaticBase;
import me.desht.pneumaticcraft.common.inventory.SlotPhantom;
import me.desht.pneumaticcraft.common.inventory.SlotPhantomUnstackable;
import me.desht.pneumaticcraft.common.item.ItemLogisticsFrame;
import me.desht.pneumaticcraft.common.semiblock.ISyncableSemiblockItem;
import me.desht.pneumaticcraft.common.tileentity.TileEntityBase;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ContainerLogistics
extends ContainerPneumaticBase<TileEntityBase>
implements ISyncableSemiblockItem {
    public final EntityLogisticsFrame logistics;
    private final boolean itemContainer;

    public ContainerLogistics(ContainerType<?> containerType, int i, PlayerInventory playerInventory, int entityId) {
        super(containerType, i, playerInventory);
        World world = playerInventory.field_70458_d.field_70170_p;
        if (entityId == -1) {
            this.logistics = EntityLogisticsFrame.fromItemStack(world, playerInventory.field_70458_d, this.getHeldLogisticsFrame(playerInventory.field_70458_d));
            this.itemContainer = true;
        } else {
            Entity e = world.func_73045_a(entityId);
            if (e instanceof EntityLogisticsFrame) {
                this.logistics = (EntityLogisticsFrame)e;
            } else {
                this.logistics = null;
                Log.error("no logistics frame entity for id %d!", entityId);
            }
            this.itemContainer = false;
        }
        if (this.logistics != null) {
            EntityLogisticsFrame.ItemFilterHandler requests = this.logistics.getItemFilterHandler();
            for (int y = 0; y < 3; ++y) {
                for (int x = 0; x < 9; ++x) {
                    this.func_75146_a((Slot)(this.logistics.canFilterStack() ? new SlotPhantom((IItemHandler)requests, y * 9 + x, x * 18 + 8, y * 18 + 29) : new SlotPhantomUnstackable((IItemHandler)requests, y * 9 + x, x * 18 + 8, y * 18 + 29)));
                }
            }
            this.addPlayerSlots(playerInventory, 134);
        }
    }

    private ContainerLogistics(ContainerType logisticsFrameRequester, int i, PlayerInventory playerInventory, PacketBuffer buffer) {
        this(logisticsFrameRequester, i, playerInventory, buffer.func_150792_a());
    }

    private ItemStack getHeldLogisticsFrame(PlayerEntity player) {
        if (player.func_184614_ca().func_77973_b() instanceof ItemLogisticsFrame) {
            return player.func_184614_ca();
        }
        if (player.func_184586_b(Hand.OFF_HAND).func_77973_b() instanceof ItemLogisticsFrame) {
            return player.func_184586_b(Hand.OFF_HAND);
        }
        return ItemStack.field_190927_a;
    }

    public boolean isItemContainer() {
        return this.itemContainer;
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayerEntity player) {
        super.handleGUIButtonPress(tag, shiftHeld, player);
        if (this.logistics != null) {
            this.logistics.handleGUIButtonPress(tag, shiftHeld, player);
        }
    }

    @Override
    public boolean func_75145_c(PlayerEntity player) {
        return this.logistics != null && this.logistics.isValid();
    }

    public void func_75134_a(PlayerEntity player) {
        if (this.itemContainer && this.logistics != null && !player.func_130014_f_().field_72995_K) {
            this.syncSemiblockItemFromClient(player, null);
        }
    }

    @Override
    @Nonnull
    public ItemStack func_82846_b(PlayerEntity player, int slotIndex) {
        Slot srcSlot = (Slot)this.field_75151_b.get(slotIndex);
        if (slotIndex >= this.playerSlotsStart && srcSlot != null && srcSlot.func_75216_d()) {
            ItemStack stackInSlot = srcSlot.func_75211_c();
            for (int i = 0; i < 27; ++i) {
                Slot slot = (Slot)this.field_75151_b.get(i);
                if (slot.func_75216_d()) continue;
                ItemStack s = this.logistics.canFilterStack() ? stackInSlot.func_77946_l() : ItemHandlerHelper.copyStackWithSize((ItemStack)stackInSlot, (int)1);
                slot.func_75215_d(s);
                break;
            }
        }
        return ItemStack.field_190927_a;
    }

    public static ContainerLogistics createProviderContainer(int i, PlayerInventory playerInventory, PacketBuffer buffer) {
        return new ContainerLogistics((ContainerType)ModContainers.LOGISTICS_FRAME_PROVIDER.get(), i, playerInventory, buffer);
    }

    public static ContainerLogistics createRequesterContainer(int i, PlayerInventory playerInventory, PacketBuffer buffer) {
        return new ContainerLogistics((ContainerType)ModContainers.LOGISTICS_FRAME_REQUESTER.get(), i, playerInventory, buffer);
    }

    public static ContainerLogistics createStorageContainer(int i, PlayerInventory playerInventory, PacketBuffer buffer) {
        return new ContainerLogistics((ContainerType)ModContainers.LOGISTICS_FRAME_STORAGE.get(), i, playerInventory, buffer);
    }

    @Override
    public void syncSemiblockItemFromClient(PlayerEntity player, PacketBuffer payload) {
        if (this.logistics != null) {
            ItemStack stack;
            if (payload != null) {
                this.logistics.readFromBuf(payload);
            }
            if (!(stack = this.getHeldLogisticsFrame(player)).func_190926_b()) {
                CompoundNBT subtag = this.logistics.serializeNBT(new CompoundNBT());
                stack.func_196082_o().func_218657_a("EntityTag", (INBT)subtag);
            }
        }
    }
}

