/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.harvesting;

import java.util.function.Predicate;
import me.desht.pneumaticcraft.common.harvesting.HarvestHandlerAbstractCrop;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class HarvestHandlerCropLike
extends HarvestHandlerAbstractCrop {
    private final IntegerProperty ageProperty;
    private final int minAge;
    private final int maxAge;
    private final Predicate<ItemStack> isSeed;

    public HarvestHandlerCropLike(Predicate<BlockState> blockChecker, IntegerProperty ageProperty, Predicate<ItemStack> isSeed) {
        super(blockChecker);
        this.ageProperty = ageProperty;
        this.isSeed = isSeed;
        this.minAge = ageProperty.func_177700_c().stream().mapToInt(Integer::intValue).min().orElse(0);
        this.maxAge = ageProperty.func_177700_c().stream().mapToInt(Integer::intValue).max().orElse(7);
    }

    @Override
    protected boolean isSeed(World world, BlockPos pos, BlockState state, ItemStack stack) {
        return this.isSeed.test(stack);
    }

    @Override
    protected boolean isMaxAge(BlockState state) {
        return (Integer)state.func_177229_b((Property)this.ageProperty) == this.maxAge;
    }

    @Override
    protected BlockState withMinAge(BlockState state) {
        return (BlockState)state.func_206870_a((Property)this.ageProperty, (Comparable)Integer.valueOf(this.minAge));
    }
}

