/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.hacking;

import java.util.HashMap;
import java.util.Map;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IHackableBlock;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IHackableEntity;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IPneumaticHelmetRegistry;
import me.desht.pneumaticcraft.client.pneumatic_armor.ArmorUpgradeClientRegistry;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.PneumaticHelmetRegistry;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.RenderBlockTarget;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.RenderEntityTarget;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.BlockTrackerClientHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.EntityTrackerClientHandler;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.hacking.WorldAndCoord;
import me.desht.pneumaticcraft.common.hacking.block.HackableButton;
import me.desht.pneumaticcraft.common.hacking.block.HackableDispenser;
import me.desht.pneumaticcraft.common.hacking.block.HackableDoor;
import me.desht.pneumaticcraft.common.hacking.block.HackableJukebox;
import me.desht.pneumaticcraft.common.hacking.block.HackableLever;
import me.desht.pneumaticcraft.common.hacking.block.HackableMobSpawner;
import me.desht.pneumaticcraft.common.hacking.block.HackableNoteblock;
import me.desht.pneumaticcraft.common.hacking.block.HackableSecurityStation;
import me.desht.pneumaticcraft.common.hacking.block.HackableSilverfish;
import me.desht.pneumaticcraft.common.hacking.block.HackableTNT;
import me.desht.pneumaticcraft.common.hacking.block.HackableTrapDoor;
import me.desht.pneumaticcraft.common.hacking.block.HackableTripwire;
import me.desht.pneumaticcraft.common.hacking.entity.HackableBat;
import me.desht.pneumaticcraft.common.hacking.entity.HackableBlaze;
import me.desht.pneumaticcraft.common.hacking.entity.HackableCaveSpider;
import me.desht.pneumaticcraft.common.hacking.entity.HackableCow;
import me.desht.pneumaticcraft.common.hacking.entity.HackableCreeper;
import me.desht.pneumaticcraft.common.hacking.entity.HackableEnderman;
import me.desht.pneumaticcraft.common.hacking.entity.HackableGhast;
import me.desht.pneumaticcraft.common.hacking.entity.HackableGuardian;
import me.desht.pneumaticcraft.common.hacking.entity.HackableHorse;
import me.desht.pneumaticcraft.common.hacking.entity.HackableItemFrame;
import me.desht.pneumaticcraft.common.hacking.entity.HackableMobDisarm;
import me.desht.pneumaticcraft.common.hacking.entity.HackablePainting;
import me.desht.pneumaticcraft.common.hacking.entity.HackableSheep;
import me.desht.pneumaticcraft.common.hacking.entity.HackableShulker;
import me.desht.pneumaticcraft.common.hacking.entity.HackableTameable;
import me.desht.pneumaticcraft.common.hacking.entity.HackableVillager;
import me.desht.pneumaticcraft.common.hacking.entity.HackableWitch;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.item.PaintingEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.BlazeEntity;
import net.minecraft.entity.monster.CaveSpiderEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.monster.GhastEntity;
import net.minecraft.entity.monster.GuardianEntity;
import net.minecraft.entity.monster.ShulkerEntity;
import net.minecraft.entity.monster.WitchEntity;
import net.minecraft.entity.passive.BatEntity;
import net.minecraft.entity.passive.CowEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.horse.HorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public class HackManager {
    private final Map<Entity, IHackableEntity> trackedHackableEntities = new HashMap<Entity, IHackableEntity>();
    private final Map<WorldAndCoord, Pair<Block, IHackableBlock>> trackedHackableBlocks = new HashMap<WorldAndCoord, Pair<Block, IHackableBlock>>();
    private static HackManager clientInstance;
    private static HackManager serverInstance;

    private static HackManager getInstance(World world) {
        if (world.field_72995_K) {
            if (clientInstance == null) {
                clientInstance = new HackManager();
            }
            return clientInstance;
        }
        if (serverInstance == null) {
            serverInstance = new HackManager();
        }
        return serverInstance;
    }

    public static void addDefaultEntries() {
        IPneumaticHelmetRegistry registry = PneumaticRegistry.getInstance().getHelmetRegistry();
        registry.addHackable(Blocks.field_150335_W, HackableTNT::new);
        registry.addHackable(Blocks.field_150474_ac, HackableMobSpawner::new);
        registry.addHackable(Blocks.field_150442_at, HackableLever::new);
        registry.addHackable(Blocks.field_150479_bC, HackableTripwire::new);
        registry.addHackable(Blocks.field_150367_z, HackableDispenser::new);
        registry.addHackable(Blocks.field_150409_cd, HackableDispenser::new);
        registry.addHackable((Block)ModBlocks.SECURITY_STATION.get(), HackableSecurityStation::new);
        registry.addHackable(Blocks.field_196687_dd, HackableSilverfish::new);
        registry.addHackable(Blocks.field_196694_dh, HackableSilverfish::new);
        registry.addHackable(Blocks.field_196692_dg, HackableSilverfish::new);
        registry.addHackable(Blocks.field_196690_df, HackableSilverfish::new);
        registry.addHackable(Blocks.field_196686_dc, HackableSilverfish::new);
        registry.addHackable(Blocks.field_196688_de, HackableSilverfish::new);
        registry.addHackable(Blocks.field_196586_al, HackableNoteblock::new);
        registry.addHackable(Blocks.field_150421_aI, HackableJukebox::new);
        registry.addHackable((ITag.INamedTag<Block>)BlockTags.field_200027_d, HackableButton::new);
        registry.addHackable((ITag.INamedTag<Block>)BlockTags.field_200029_f, HackableDoor::new);
        registry.addHackable((ITag.INamedTag<Block>)BlockTags.field_212185_E, HackableTrapDoor::new);
        registry.addHackable(LivingEntity.class, HackableMobDisarm::new);
        registry.addHackable(CreeperEntity.class, HackableCreeper::new);
        registry.addHackable(TameableEntity.class, HackableTameable::new);
        registry.addHackable(CowEntity.class, HackableCow::new);
        registry.addHackable(SheepEntity.class, HackableSheep::new);
        registry.addHackable(CaveSpiderEntity.class, HackableCaveSpider::new);
        registry.addHackable(BlazeEntity.class, HackableBlaze::new);
        registry.addHackable(GhastEntity.class, HackableGhast::new);
        registry.addHackable(WitchEntity.class, HackableWitch::new);
        registry.addHackable(EndermanEntity.class, HackableEnderman::new);
        registry.addHackable(BatEntity.class, HackableBat::new);
        registry.addHackable(HorseEntity.class, HackableHorse::new);
        registry.addHackable(ShulkerEntity.class, HackableShulker::new);
        registry.addHackable(GuardianEntity.class, HackableGuardian::new);
        registry.addHackable(VillagerEntity.class, HackableVillager::new);
        registry.addHackable(PaintingEntity.class, HackablePainting::new);
        registry.addHackable(ItemFrameEntity.class, HackableItemFrame::new);
    }

    public static IHackableEntity getHackableForEntity(Entity entity, PlayerEntity player) {
        HackManager.getInstance((World)player.func_130014_f_()).trackedHackableEntities.entrySet().removeIf(entry -> !((Entity)entry.getKey()).func_70089_S() || !((IHackableEntity)entry.getValue()).canHack((Entity)entry.getKey(), player) && !HackManager.isInDisplayCooldown((IHackableEntity)entry.getValue(), (Entity)entry.getKey()));
        if (entity instanceof IHackableEntity && ((IHackableEntity)entity).canHack(entity, player)) {
            return (IHackableEntity)entity;
        }
        IHackableEntity hackable = HackManager.getInstance((World)player.func_130014_f_()).trackedHackableEntities.get(entity);
        if (hackable == null && (hackable = PneumaticHelmetRegistry.getInstance().getHackable(entity, player)) != null) {
            HackManager.getInstance((World)player.func_130014_f_()).trackedHackableEntities.put(entity, hackable);
        }
        return hackable;
    }

    public static IHackableBlock getHackableForBlock(IBlockReader world, BlockPos pos, PlayerEntity player) {
        Block block = world.func_180495_p(pos).func_177230_c();
        HackManager.getInstance((World)player.func_130014_f_()).trackedHackableBlocks.entrySet().removeIf(entry -> {
            Block trackedBlock = (Block)((Pair)entry.getValue()).getLeft();
            IHackableBlock hackableBlock = (IHackableBlock)((Pair)entry.getValue()).getRight();
            return block != trackedBlock || !hackableBlock.canHack(((WorldAndCoord)entry.getKey()).world, ((WorldAndCoord)entry.getKey()).pos, player) && !HackManager.isInDisplayCooldown(hackableBlock, ((WorldAndCoord)entry.getKey()).world, ((WorldAndCoord)entry.getKey()).pos, player);
        });
        if (block instanceof IHackableBlock && ((IHackableBlock)block).canHack(world, pos, player)) {
            return (IHackableBlock)block;
        }
        WorldAndCoord loc = new WorldAndCoord(world, pos);
        Pair pair = HackManager.getInstance((World)player.func_130014_f_()).trackedHackableBlocks.get(loc);
        if (pair == null) {
            IHackableBlock hackable = PneumaticHelmetRegistry.getInstance().getHackable(block);
            if (hackable != null && hackable.canHack(world, pos, player)) {
                pair = Pair.of((Object)block, (Object)hackable);
                HackManager.getInstance((World)player.func_130014_f_()).trackedHackableBlocks.put(loc, (Pair<Block, IHackableBlock>)pair);
            } else {
                return null;
            }
        }
        return (IHackableBlock)pair.getRight();
    }

    private static boolean isInDisplayCooldown(IHackableBlock hackableBlock, IBlockReader world, BlockPos pos, PlayerEntity player) {
        if (player.field_70170_p.field_72995_K) {
            RenderBlockTarget target = ArmorUpgradeClientRegistry.getInstance().getClientHandler(ArmorUpgradeRegistry.getInstance().blockTrackerHandler, BlockTrackerClientHandler.class).getTargetForCoord(pos);
            int requiredHackTime = hackableBlock.getHackTime(world, pos, player);
            return target != null && target.getHackTime() >= requiredHackTime && target.getHackTime() <= requiredHackTime + 20;
        }
        return false;
    }

    private static boolean isInDisplayCooldown(IHackableEntity hackableEntity, Entity entity) {
        if (entity.field_70170_p.field_72995_K) {
            RenderEntityTarget target = ArmorUpgradeClientRegistry.getInstance().getClientHandler(ArmorUpgradeRegistry.getInstance().entityTrackerHandler, EntityTrackerClientHandler.class).getTargetForEntity(entity);
            int requiredHackTime = hackableEntity.getHackTime(entity, ClientUtils.getClientPlayer());
            return target != null && target.getHackTime() >= requiredHackTime && target.getHackTime() <= requiredHackTime + 20;
        }
        return false;
    }
}

