/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.entity.semiblock;

import me.desht.pneumaticcraft.api.semiblock.ISemiBlock;
import me.desht.pneumaticcraft.common.entity.semiblock.EntitySemiblockBase;
import me.desht.pneumaticcraft.common.semiblock.SemiblockTracker;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityType;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.world.World;
import net.minecraft.world.spawner.AbstractSpawner;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class EntitySpawnerAgitator
extends EntitySemiblockBase {
    public EntitySpawnerAgitator(EntityType<?> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
    }

    @Override
    public boolean canPlace(Direction facing) {
        return this.getBlockState().func_177230_c() == Blocks.field_150474_ac;
    }

    @Override
    public void func_70071_h_() {
        AbstractSpawner spawner;
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && (spawner = this.getSpawner()) != null) {
            spawner.field_98289_l = Integer.MAX_VALUE;
            if (this.field_70173_aa == 1) {
                this.setSpawnPersistentEntities(spawner, true);
            }
        }
    }

    @Override
    public void onBroken() {
        AbstractSpawner spawner;
        super.onBroken();
        if (!this.field_70170_p.field_72995_K && (spawner = this.getSpawner()) != null) {
            spawner.field_98289_l = 16;
            this.setSpawnPersistentEntities(spawner, false);
        }
    }

    private AbstractSpawner getSpawner() {
        TileEntity te = this.getCachedTileEntity();
        return te instanceof MobSpawnerTileEntity ? ((MobSpawnerTileEntity)te).func_145881_a() : null;
    }

    private void setSpawnPersistentEntities(AbstractSpawner spawner, boolean persistent) {
        spawner.field_98282_f.func_185277_b().func_74757_a("PersistenceRequired", persistent);
    }

    @Mod.EventBusSubscriber(modid="pneumaticcraft")
    public static class Listener {
        @SubscribeEvent
        public static void onBlockBreak(BlockEvent.BreakEvent event) {
            AbstractSpawner spawner;
            ISemiBlock semi;
            if (event.getState().func_177230_c() == Blocks.field_150474_ac && event.getWorld() instanceof World && (semi = SemiblockTracker.getInstance().getSemiblock((World)event.getWorld(), event.getPos())) instanceof EntitySpawnerAgitator && (spawner = ((EntitySpawnerAgitator)semi).getSpawner()) != null) {
                spawner.field_98289_l = 16;
                ((EntitySpawnerAgitator)semi).setSpawnPersistentEntities(spawner, false);
            }
        }
    }
}

